/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.searchspace.HasMetric;

public class Diversity
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public Diversity(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getGenotypeSearchSpace() instanceof HasMetric)) {
            throw new UnsupportedEnvironmentException("Search space has no metric.");
        }
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public String getName() {
        return "Diversity";
    }

    public String getDescription() {
        return "Computes the individuals' diversity, the average distance between pairs of individuals.";
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] individuals = individualList.toArray();
        HasMetric searchSpace = (HasMetric)((Object)this.getSchedule().getGenotypeSearchSpace());
        double sum = 0.0;
        int i = 0;
        while (i < individuals.length) {
            int j = i + 1;
            while (j < individuals.length) {
                sum += searchSpace.getDistance(individuals[i].getGenotype(), individuals[j].getGenotype());
                ++j;
            }
            ++i;
        }
        double average = sum * 2.0 / (double)(individuals.length * (individuals.length - 1));
        this.updateViews(new Double(average));
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

