/*
 * This file is part of RFrEAK. For licensing and copyright information
 * please see the file COPYING in the root directory of this
 * distribution or contact <robin.nunkesser@udo.edu>.
 * 
 * This file is a modification of the original file distributed with
 * FrEAK (http://sourceforge.net/projects/freak427/).
 * Last modification: 07/11/2007
 */

package freak.gui.runframe;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

/**
 * Autogenerated Menu.
 * @author  Stefan
 */
public class RunFrameUI extends AbstractRunFrame {
	protected FreakDesktopPane desktop;
	protected ReplayPanel blinkingR;
	
	public void viewFilenameInTitle(String s)
	{
		setTitle("RFrEAK "+s);
	}
	
	public RunFrameUI() {
		initComponents();
		changeDesktop();
		addAccelerators();
		if (UIManager.getLookAndFeel().getID().equals("Aqua")) {
			aquaLayoutAdaptions();
		} else if (UIManager.getLookAndFeel().getID().equals("Metal"))  {
			metalLayoutAdaptions();
		}
		pack();
	}
	
	private void changeDesktop() {
		desktop = new FreakDesktopPane();
		blinkingR = new ReplayPanel();
		ROverlayPane rPane = new ROverlayPane(desktop.getDelegate(), blinkingR);
				
		desktopPanel.removeAll();
		desktopPanel.add(rPane);
	}
	
	private void addAccelerators() {
		int modifier =  Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
		jMenuItemNew.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, modifier));
		jMenuItemOpen.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, modifier));
		jMenuItemSave.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, modifier));
		jMenuItemExit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, modifier));
		jMenuItemEdit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, modifier));
		jMenuItemHelp.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0));
	}
	
	private void aquaLayoutAdaptions() {
	    jButtonSkipToStart.setMargin(new java.awt.Insets(11, 25, 8, 22));
        jButtonSkipBack.setMargin(new java.awt.Insets(11, 25, 8, 22));
        jButtonSuspend.setMargin(new java.awt.Insets(11, 25, 8, 22));
		jButtonStart.setMargin(new java.awt.Insets(11, 25, 8, 22));
        jButtonSkipForward.setMargin(new java.awt.Insets(11, 25, 8, 22));
        jButtonSkipToEnd.setMargin(new java.awt.Insets(11, 25, 8, 22));
		
		GridBagLayout cpLayout = (GridBagLayout)controlPanel.getLayout();
		GridBagConstraints constraints = cpLayout.getConstraints(jSliderGeneration);
		constraints.insets.bottom = 0;
		cpLayout.setConstraints(jSliderGeneration, constraints);
		
		((GridLayout)buttonPanel.getLayout()).setHgap(0);
		
		controlPanel.setBorder(new EmptyBorder(4, 9, 12, 9));
		constraints = cpLayout.getConstraints(buttonPanel);
		constraints.insets.left = 5;
		cpLayout.setConstraints(buttonPanel, constraints);
		
		infoPanel.setBorder(new EmptyBorder(12, 14, 12, 12));
		
		jButtonStart.setText("");
   	}
	
	private void metalLayoutAdaptions() {
		controlPanel.setBorder(new EmptyBorder(12, 6, 12, 6));
		GridBagLayout cpLayout = (GridBagLayout)controlPanel.getLayout();
		GridBagConstraints constraints = cpLayout.getConstraints(buttonPanel);
		constraints.insets.left = 6;
		cpLayout.setConstraints(buttonPanel, constraints);
   	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        rootPanel = new javax.swing.JPanel();
        infoPanel = new javax.swing.JPanel();
        jLabelSearchSpace = new javax.swing.JLabel();
        jLabelFitnessFunction = new javax.swing.JLabel();
        jLabelRun = new javax.swing.JLabel();
        jLabelGeneration = new javax.swing.JLabel();
        jSpinnerRun = new javax.swing.JSpinner();
        jSpinnerGeneration = new javax.swing.JSpinner();
        jLabelBatch = new javax.swing.JLabel();
        jSpinnerBatch = new javax.swing.JSpinner();
        spacer1 = new javax.swing.JPanel();
        jButtonQuickStart = new javax.swing.JButton();
        controlPanel = new javax.swing.JPanel();
        jSliderSpeed = new javax.swing.JSlider();
        jLabelSpeed = new javax.swing.JLabel();
        speedLimitCheckBox = new javax.swing.JCheckBox();
        jSliderGeneration = new javax.swing.JSlider();
        buttonPanel = new javax.swing.JPanel();
        jButtonSkipToStart = new javax.swing.JButton();
        jButtonSkipBack = new javax.swing.JButton();
        jButtonSuspend = new javax.swing.JButton();
        jButtonStart = new javax.swing.JButton();
        jButtonSkipForward = new javax.swing.JButton();
        jButtonSkipToEnd = new javax.swing.JButton();
        spacer2 = new javax.swing.JPanel();
        jTextFieldSpeed = new javax.swing.JTextField();
        spacer3 = new javax.swing.JPanel();
        desktopPanel = new javax.swing.JPanel();
        jDesktopPane1 = new javax.swing.JDesktopPane();
        jSeparator3 = new javax.swing.JSeparator();
        jSeparator4 = new javax.swing.JSeparator();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuItemNew = new javax.swing.JMenuItem();
        jMenuItemOpen = new javax.swing.JMenuItem();
        jMenuItemSave = new javax.swing.JMenuItem();
        jMenuItemSaveAs = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        jMenuItemExit = new javax.swing.JMenuItem();
        jMenuEdit = new javax.swing.JMenu();
        jMenuItemEdit = new javax.swing.JMenuItem();
        jMenuItemConfigureView = new javax.swing.JMenuItem();
        jMenuControl = new javax.swing.JMenu();
        jMenuItemStart = new javax.swing.JMenuItem();
        jMenuItemSuspend = new javax.swing.JMenuItem();
        jSeparator5 = new javax.swing.JSeparator();
        jMenuItemSkipBack = new javax.swing.JMenuItem();
        jMenuItemSkipForward = new javax.swing.JMenuItem();
        jMenuItemSkipToStart = new javax.swing.JMenuItem();
        jMenuItemSkipToEnd = new javax.swing.JMenuItem();
        jSeparator6 = new javax.swing.JSeparator();
        jMenuItemGoTo = new javax.swing.JMenuItem();
        jMenuViews = new javax.swing.JMenu();
        jMenuItemTile = new javax.swing.JMenuItem();
        jMenuItemCascade = new javax.swing.JMenuItem();
        jMenuItemMinimize = new javax.swing.JMenuItem();
        jMenuItemRestore = new javax.swing.JMenuItem();
        jMenuItemClose = new javax.swing.JMenuItem();
        jMenuHelp = new javax.swing.JMenu();
        jMenuItemHelp = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JSeparator();
        jMenuItemAbout = new javax.swing.JMenuItem();

        setTitle("RFrEAK");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        rootPanel.setLayout(new java.awt.GridBagLayout());

        infoPanel.setLayout(new java.awt.GridBagLayout());

        infoPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 12, 12, 12)));
        jLabelSearchSpace.setFont(new java.awt.Font("Dialog", 1, 18));
        jLabelSearchSpace.setText("Search Space");
        jLabelSearchSpace.setToolTipText("The search space of the current schedule");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        infoPanel.add(jLabelSearchSpace, gridBagConstraints);

        jLabelFitnessFunction.setText("Fitness Function");
        jLabelFitnessFunction.setToolTipText("The fitness function of the current schedule");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        infoPanel.add(jLabelFitnessFunction, gridBagConstraints);

        jLabelRun.setText("Run:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(11, 0, 0, 0);
        infoPanel.add(jLabelRun, gridBagConstraints);

        jLabelGeneration.setText("Generation:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(11, 0, 0, 0);
        infoPanel.add(jLabelGeneration, gridBagConstraints);

        jSpinnerRun.setToolTipText("Jump to a different run  in the current batch");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        infoPanel.add(jSpinnerRun, gridBagConstraints);

        jSpinnerGeneration.setToolTipText("Jump to a different generation in the current run");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        infoPanel.add(jSpinnerGeneration, gridBagConstraints);

        jLabelBatch.setText("Batch:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(24, 0, 0, 0);
        infoPanel.add(jLabelBatch, gridBagConstraints);

        jSpinnerBatch.setToolTipText("Jump to a different batch");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        infoPanel.add(jSpinnerBatch, gridBagConstraints);

        spacer1.setLayout(new java.awt.BorderLayout());

        spacer1.setMinimumSize(new java.awt.Dimension(120, 6));
        spacer1.setPreferredSize(new java.awt.Dimension(120, 200));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        infoPanel.add(spacer1, gridBagConstraints);

        jButtonQuickStart.setText("Quick Start GPAS");
        jButtonQuickStart.setToolTipText("Get a simplified dialog to start GPAS");
        jButtonQuickStart.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        jButtonQuickStart.setMargin(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        infoPanel.add(jButtonQuickStart,gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        rootPanel.add(infoPanel, gridBagConstraints);

        controlPanel.setLayout(new java.awt.GridBagLayout());

        controlPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(6, 12, 12, 12)));
        jSliderSpeed.setMaximum(500);
        jSliderSpeed.setMinimum(-100);
        jSliderSpeed.setToolTipText("Speed limit");
        jSliderSpeed.setValue(100);
        jSliderSpeed.setMinimumSize(null);
        jSliderSpeed.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        controlPanel.add(jSliderSpeed, gridBagConstraints);

        jLabelSpeed.setText("Speed Limit:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 6);
        controlPanel.add(jLabelSpeed, gridBagConstraints);

        speedLimitCheckBox.setSelected(true);
        speedLimitCheckBox.setToolTipText("Enable or disable speed limit");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
        controlPanel.add(speedLimitCheckBox, gridBagConstraints);

        jSliderGeneration.setMajorTickSpacing(20);
        jSliderGeneration.setMinorTickSpacing(1);
        jSliderGeneration.setPaintLabels(true);
        jSliderGeneration.setPaintTicks(true);
        jSliderGeneration.setMinimumSize(null);
        jSliderGeneration.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 0);
        controlPanel.add(jSliderGeneration, gridBagConstraints);

        buttonPanel.setLayout(new java.awt.GridLayout(1, 0));

        jButtonSkipToStart.setIcon(new javax.swing.ImageIcon(getClass().getResource("/freak/gui/runframe/StepBackFar.gif")));
        jButtonSkipToStart.setToolTipText("Go back to the start of the simulation");
        jButtonSkipToStart.setMargin(null);
        buttonPanel.add(jButtonSkipToStart);

        jButtonSkipBack.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/media/StepBack16.gif")));
        jButtonSkipBack.setToolTipText("Step back to the last start of a run");
        jButtonSkipBack.setMargin(null);
        buttonPanel.add(jButtonSkipBack);

        jButtonSuspend.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/media/Pause16.gif")));
        jButtonSuspend.setToolTipText("Suspend");
        buttonPanel.add(jButtonSuspend);

        jButtonStart.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/media/Play16.gif")));
        jButtonStart.setToolTipText("Start");
        jButtonStart.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        jButtonStart.setMargin(null);
        buttonPanel.add(jButtonStart);

        jButtonSkipForward.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/media/StepForward16.gif")));
        jButtonSkipForward.setToolTipText("Jump to the start of the next run");
        jButtonSkipForward.setMargin(null);
        buttonPanel.add(jButtonSkipForward);

        jButtonSkipToEnd.setIcon(new javax.swing.ImageIcon(getClass().getResource("/freak/gui/runframe/StepForwardFar.gif")));
        jButtonSkipToEnd.setToolTipText("Jump forward to the last known generation");
        jButtonSkipToEnd.setMargin(null);
        buttonPanel.add(jButtonSkipToEnd);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        controlPanel.add(buttonPanel, gridBagConstraints);

        spacer2.setLayout(new java.awt.BorderLayout());

        spacer2.setMinimumSize(new java.awt.Dimension(100, 0));
        spacer2.setPreferredSize(new java.awt.Dimension(300, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        controlPanel.add(spacer2, gridBagConstraints);

        jTextFieldSpeed.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        jTextFieldSpeed.setText("10.00");
        jTextFieldSpeed.setToolTipText("Speed limit in generations per second");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
        controlPanel.add(jTextFieldSpeed, gridBagConstraints);

        spacer3.setLayout(new java.awt.BorderLayout());

        spacer3.setMinimumSize(new java.awt.Dimension(80, 0));
        spacer3.setPreferredSize(new java.awt.Dimension(80, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
        controlPanel.add(spacer3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        rootPanel.add(controlPanel, gridBagConstraints);

        desktopPanel.setLayout(new java.awt.BorderLayout());

        desktopPanel.add(jDesktopPane1, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        rootPanel.add(desktopPanel, gridBagConstraints);

        jSeparator3.setMinimumSize(new java.awt.Dimension(0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        rootPanel.add(jSeparator3, gridBagConstraints);

        jSeparator4.setOrientation(javax.swing.SwingConstants.VERTICAL);
        jSeparator4.setMinimumSize(new java.awt.Dimension(2, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        rootPanel.add(jSeparator4, gridBagConstraints);

        getContentPane().add(rootPanel, java.awt.BorderLayout.CENTER);

        jMenuFile.setMnemonic('F');
        jMenuFile.setText("File");
        jMenuItemNew.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/New16.gif")));
        jMenuItemNew.setMnemonic('N');
        jMenuItemNew.setText("New...");
        jMenuItemNew.setToolTipText("Create a new schedule");
        jMenuFile.add(jMenuItemNew);

        jMenuItemOpen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
        jMenuItemOpen.setMnemonic('O');
        jMenuItemOpen.setText("Open...");
        jMenuItemOpen.setToolTipText("Load a schedule");
        jMenuFile.add(jMenuItemOpen);

        jMenuItemSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Save16.gif")));
        jMenuItemSave.setMnemonic('S');
        jMenuItemSave.setText("Save");
        jMenuItemSave.setToolTipText("Save the current schedule");
        jMenuFile.add(jMenuItemSave);

        jMenuItemSaveAs.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif")));
        jMenuItemSaveAs.setMnemonic('A');
        jMenuItemSaveAs.setText("Save As...");
        jMenuItemSaveAs.setToolTipText("Save the current schedule to a different location");
        jMenuFile.add(jMenuItemSaveAs);

        jMenuFile.addSeparator();

        jMenuItemExit.setMnemonic('X');
        jMenuItemExit.setText("Exit");
        jMenuItemExit.setToolTipText("Terminate FrEAK");
        jMenuFile.add(jMenuItemExit);

        jMenuBar1.add(jMenuFile);

        jMenuEdit.setMnemonic('E');
        jMenuEdit.setText("Edit");
        jMenuItemEdit.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Edit16.gif")));
        jMenuItemEdit.setMnemonic('E');
        jMenuItemEdit.setText("Edit Schedule...");
        jMenuItemEdit.setToolTipText("Modify the configuration of the current schedule");
        jMenuEdit.add(jMenuItemEdit);

        jMenuItemConfigureView.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        jMenuItemConfigureView.setMnemonic('C');
        jMenuItemConfigureView.setText("Configure Selected View");
        jMenuItemConfigureView.setToolTipText("Modify the configuration of the selected view");
        jMenuEdit.add(jMenuItemConfigureView);

        jMenuBar1.add(jMenuEdit);

        jMenuControl.setMnemonic('C');
        jMenuControl.setText("Control");
        jMenuItemStart.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/media/Play16.gif")));
        jMenuItemStart.setMnemonic('S');
        jMenuItemStart.setText("Start");
        jMenuItemStart.setToolTipText("Start or continue the current Schedule");
        jMenuControl.add(jMenuItemStart);

        jMenuItemSuspend.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/media/Pause16.gif")));
        jMenuItemSuspend.setMnemonic('P');
        jMenuItemSuspend.setText("Suspend");
        jMenuItemSuspend.setToolTipText("Pause the current Schedule");
        jMenuControl.add(jMenuItemSuspend);

        jMenuControl.addSeparator();

        jMenuItemSkipBack.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/media/StepBack16.gif")));
        jMenuItemSkipBack.setText("Step Back");
        jMenuItemSkipBack.setToolTipText("Step back to the last start of a run");
        jMenuControl.add(jMenuItemSkipBack);

        jMenuItemSkipForward.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/media/StepForward16.gif")));
        jMenuItemSkipForward.setText("Skip Run");
        jMenuItemSkipForward.setToolTipText("Jump to the start of the next run");
        jMenuControl.add(jMenuItemSkipForward);

        jMenuItemSkipToStart.setIcon(new javax.swing.ImageIcon(getClass().getResource("/freak/gui/runframe/StepBackFar.gif")));
        jMenuItemSkipToStart.setText("Go to Start");
        jMenuItemSkipToStart.setToolTipText("Go back to the start of the simulation");
        jMenuControl.add(jMenuItemSkipToStart);

        jMenuItemSkipToEnd.setIcon(new javax.swing.ImageIcon(getClass().getResource("/freak/gui/runframe/StepForwardFar.gif")));
        jMenuItemSkipToEnd.setText("Go to End");
        jMenuItemSkipToEnd.setToolTipText("Jump forward to the last known generation");
        jMenuControl.add(jMenuItemSkipToEnd);

        jMenuControl.addSeparator();

        jMenuItemGoTo.setMnemonic('G');
        jMenuItemGoTo.setText("Go to...");
        jMenuItemGoTo.setToolTipText("Jump to a specified generation");
        jMenuControl.add(jMenuItemGoTo);

        jMenuBar1.add(jMenuControl);

        jMenuViews.setMnemonic('V');
        jMenuViews.setText("Views");
        jMenuItemTile.setMnemonic('T');
        jMenuItemTile.setText("Tile");
        jMenuViews.add(jMenuItemTile);

        jMenuItemCascade.setMnemonic('C');
        jMenuItemCascade.setText("Cascade");
        jMenuViews.add(jMenuItemCascade);

        jMenuItemMinimize.setMnemonic('M');
        jMenuItemMinimize.setText("Minimize All");
        jMenuViews.add(jMenuItemMinimize);

        jMenuItemRestore.setMnemonic('R');
        jMenuItemRestore.setText("Restore All");
        jMenuViews.add(jMenuItemRestore);

        jMenuItemClose.setMnemonic('C');
        jMenuItemClose.setText("Close All");
        jMenuViews.add(jMenuItemClose);

        jMenuBar1.add(jMenuViews);

        jMenuHelp.setMnemonic('H');
        jMenuHelp.setText("Help");
        jMenuItemHelp.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Help16.gif")));
        jMenuItemHelp.setMnemonic('H');
        jMenuItemHelp.setText("Help");
        jMenuItemHelp.setToolTipText("Show the reference manual");
        jMenuHelp.add(jMenuItemHelp);

        jMenuHelp.addSeparator();

        jMenuItemAbout.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/About16.gif")));
        jMenuItemAbout.setMnemonic('A');
        jMenuItemAbout.setText("About");
        jMenuItemAbout.setToolTipText("Show version and license information");
        jMenuHelp.add(jMenuItemAbout);

        jMenuBar1.add(jMenuHelp);

        setJMenuBar(jMenuBar1);

        pack();
    }//GEN-END:initComponents

	/** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt) { //GEN-FIRST:event_exitForm
		System.exit(0);
	} //GEN-LAST:event_exitForm

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) throws Exception {
		//System.out.println(Arrays.asList(UIManager.getInstalledLookAndFeels()));
		//UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
		//UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
		RunFrameUI f = new RunFrameUI();
		
		f.setLocationRelativeTo(null);
		f.setVisible(true);
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JPanel buttonPanel;
    protected javax.swing.JPanel controlPanel;
    protected javax.swing.JPanel desktopPanel;
    protected javax.swing.JPanel infoPanel;
    protected javax.swing.JButton jButtonQuickStart;
    protected javax.swing.JButton jButtonSkipBack;
    protected javax.swing.JButton jButtonSkipForward;
    protected javax.swing.JButton jButtonSkipToEnd;
    protected javax.swing.JButton jButtonSkipToStart;
    protected javax.swing.JButton jButtonStart;
    protected javax.swing.JButton jButtonSuspend;
    protected javax.swing.JDesktopPane jDesktopPane1;
    protected javax.swing.JLabel jLabelBatch;
    protected javax.swing.JLabel jLabelFitnessFunction;
    protected javax.swing.JLabel jLabelGeneration;
    protected javax.swing.JLabel jLabelRun;
    protected javax.swing.JLabel jLabelSearchSpace;
    protected javax.swing.JLabel jLabelSpeed;
    protected javax.swing.JMenuBar jMenuBar1;
    protected javax.swing.JMenu jMenuControl;
    protected javax.swing.JMenu jMenuEdit;
    protected javax.swing.JMenu jMenuFile;
    protected javax.swing.JMenu jMenuHelp;
    protected javax.swing.JMenuItem jMenuItemAbout;
    protected javax.swing.JMenuItem jMenuItemCascade;
    protected javax.swing.JMenuItem jMenuItemClose;
    protected javax.swing.JMenuItem jMenuItemConfigureView;
    protected javax.swing.JMenuItem jMenuItemEdit;
    protected javax.swing.JMenuItem jMenuItemExit;
    protected javax.swing.JMenuItem jMenuItemGoTo;
    protected javax.swing.JMenuItem jMenuItemHelp;
    protected javax.swing.JMenuItem jMenuItemMinimize;
    protected javax.swing.JMenuItem jMenuItemNew;
    protected javax.swing.JMenuItem jMenuItemOpen;
    protected javax.swing.JMenuItem jMenuItemRestore;
    protected javax.swing.JMenuItem jMenuItemSave;
    protected javax.swing.JMenuItem jMenuItemSaveAs;
    protected javax.swing.JMenuItem jMenuItemSkipBack;
    protected javax.swing.JMenuItem jMenuItemSkipForward;
    protected javax.swing.JMenuItem jMenuItemSkipToEnd;
    protected javax.swing.JMenuItem jMenuItemSkipToStart;
    protected javax.swing.JMenuItem jMenuItemStart;
    protected javax.swing.JMenuItem jMenuItemSuspend;
    protected javax.swing.JMenuItem jMenuItemTile;
    protected javax.swing.JMenu jMenuViews;
    protected javax.swing.JSeparator jSeparator1;
    protected javax.swing.JSeparator jSeparator2;
    protected javax.swing.JSeparator jSeparator3;
    protected javax.swing.JSeparator jSeparator4;
    protected javax.swing.JSeparator jSeparator5;
    protected javax.swing.JSeparator jSeparator6;
    protected javax.swing.JSlider jSliderGeneration;
    protected javax.swing.JSlider jSliderSpeed;
    protected javax.swing.JSpinner jSpinnerBatch;
    protected javax.swing.JSpinner jSpinnerGeneration;
    protected javax.swing.JSpinner jSpinnerRun;
    protected javax.swing.JTextField jTextFieldSpeed;
    protected javax.swing.JPanel rootPanel;
    protected javax.swing.JPanel spacer1;
    protected javax.swing.JPanel spacer2;
    private javax.swing.JPanel spacer3;
    protected javax.swing.JCheckBox speedLimitCheckBox;
    // End of variables declaration//GEN-END:variables

}
