/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.services;

import edu.ucsb.cs.jicos.services.Client;
import edu.ucsb.cs.jicos.services.ClientProfile;
import edu.ucsb.cs.jicos.services.ClientToHsp;
import edu.ucsb.cs.jicos.services.ComputeException;
import edu.ucsb.cs.jicos.services.Environment;
import edu.ucsb.cs.jicos.services.HspAgent;
import edu.ucsb.cs.jicos.services.HspState;
import edu.ucsb.cs.jicos.services.Invoice;
import edu.ucsb.cs.jicos.services.JicosException;
import edu.ucsb.cs.jicos.services.Result;
import edu.ucsb.cs.jicos.services.ResultId;
import edu.ucsb.cs.jicos.services.Task;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public final class Client2Hsp {
    private Client client;
    private ClientToHsp hsp;
    private HspAgent hspAgent;
    private boolean login;

    Client2Hsp(ClientToHsp clientToHsp, HspAgent hspAgent) throws RemoteException {
        this.hsp = clientToHsp;
        this.hspAgent = hspAgent;
    }

    public Object compute(Task task) throws ComputeException, JicosException, RemoteException {
        return this.hsp.compute(task);
    }

    public HspState getState() throws RemoteException {
        return this.hsp.getState();
    }

    public Result getResult() throws ComputeException, JicosException, RemoteException {
        return this.hsp.getResult();
    }

    public void login(Environment environment) throws RemoteException {
        this.client = new Client();
        ClientProfile clientProfile = new ClientProfile(this.client);
        if (this.login) {
            throw new IllegalStateException();
        }
        this.login = true;
        this.hsp.login(this.client.serviceName(), clientProfile, environment);
    }

    public Invoice logout() throws RemoteException {
        Invoice invoice = this.hsp.logout();
        UnicastRemoteObject.unexportObject(this.client, true);
        this.login = false;
        return invoice;
    }

    public ResultId setComputation(Task task) throws RemoteException {
        return this.hsp.setComputation(task);
    }
}

