/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer.isingmodelcliques;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.stoppingcriterion.StoppingCriterion;
import freak.module.stoppingcriterion.IsingModelCliquesFinished;

public class CliquesIdenticallyColored
extends AbstractObserver
implements RunEventListener {
    private IsingModelCliquesFinished sc = null;

    public CliquesIdenticallyColored(Schedule schedule) {
        super(schedule);
        this.setMeasure(2);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        StoppingCriterion[] stoppingCriteria = schedule.getStoppingCriteria();
        int i = 0;
        while (i < stoppingCriteria.length) {
            if (stoppingCriteria[i] instanceof IsingModelCliquesFinished) {
                this.sc = (IsingModelCliquesFinished)stoppingCriteria[i];
            }
            ++i;
        }
        if (this.sc == null) {
            throw new UnsupportedEnvironmentException();
        }
    }

    public Class getOutputDataType() {
        return Boolean.class;
    }

    public String getName() {
        return "Cliques Identically Colored";
    }

    public String getDescription() {
        return "Computes whether all cliques are colored identically when the run is finished.";
    }

    public void runFinalize(RunEvent evt) {
        this.updateViews(new Boolean(this.sc.getAllCliquesColoredIdentically()));
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }
}

