/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.permutation;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.Permutation;
import freak.module.searchspace.PermutationGenotype;
import java.util.Stack;

public class Sort_REM
extends AbstractStaticSingleObjectiveFitnessFunction {
    public Sort_REM(Schedule schedule) {
        super(schedule);
    }

    protected double evaluate(Genotype genotype) {
        return this.calculateREM((PermutationGenotype)genotype);
    }

    public String getName() {
        return "Sorting with measure REM";
    }

    public String getDescription() {
        return "The sorting problem can be viewed as an optimization problem: the sortedness of a sequence has to be maximized. We assume a_1 < a_2 < ... < a_n, so the optimal permutation is the identity. \nThe measure of sortedness used by this fitness function is REM.\nREM(pi) equals the largest k such that pi(i_1) < ... < pi(i_k) for some i_1 < ... < i_k (length of the longest sorted subsequence)";
    }

    private int calculateREM(PermutationGenotype gt) {
        int[] a = gt.getIntArray();
        IntStack[] stack = new IntStack[a.length];
        int r = 0;
        stack[0] = new IntStack();
        stack[0].push(a[0]);
        ++r;
        int i = 1;
        while (i < a.length) {
            if (a[i] > stack[r - 1].peek()) {
                stack[r] = new IntStack();
                stack[r].push(a[i]);
                ++r;
            } else {
                int left = 0;
                int right = r - 1;
                int middle = left + (int)Math.floor((right - left) / 2);
                while (right - left > 0) {
                    if (right - left < 3) {
                        boolean found = false;
                        int j = left;
                        while (!found) {
                            if (a[i] < stack[j].peek()) {
                                found = true;
                                left = right = j;
                                continue;
                            }
                            ++j;
                        }
                        continue;
                    }
                    if (a[i] < stack[middle].peek()) {
                        right = middle;
                    } else {
                        left = middle;
                    }
                    middle = left + (int)Math.floor((right - left) / 2);
                }
                stack[left].push(a[i]);
            }
            ++i;
        }
        return r;
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int n = ((Permutation)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int[] a = new int[n];
        int i = 0;
        while (i < n) {
            a[i] = i;
            ++i;
        }
        return new PermutationGenotype(a);
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return ((Permutation)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    private class IntStack {
        private Stack stack = new Stack();

        public void push(int k) {
            this.stack.push(new Integer(k));
        }

        public int pop() {
            return (Integer)this.stack.pop();
        }

        public int peek() {
            return (Integer)this.stack.peek();
        }
    }
}

