/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import java.io.Serializable;

public class RunIndex
implements Comparable,
Serializable {
    public final int batch;
    public final int run;

    public RunIndex(int batch, int run) {
        this.batch = batch;
        this.run = run;
    }

    public RunIndex nextRun() {
        if (this.batch == 0) {
            return new RunIndex(1, 1);
        }
        if (this.run == Integer.MAX_VALUE) {
            return new RunIndex(this.batch + 1, 1);
        }
        return new RunIndex(this.batch, this.run + 1);
    }

    public RunIndex nextBatchStart() {
        if (this.batch == 0) {
            return new RunIndex(1, 1);
        }
        return new RunIndex(this.batch + 1, 1);
    }

    public int compareTo(Object other) {
        RunIndex t = (RunIndex)other;
        if (this.batch != t.batch) {
            return this.batch - t.batch;
        }
        return this.run - t.run;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof RunIndex)) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.batch + this.run;
    }

    public String toString() {
        return "Batch: " + this.batch + ", Run: " + this.run;
    }
}

