/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.common;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.SearchSpace;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;
import java.util.BitSet;

public class UniformCrossover
extends MultiPairwiseCrossover
implements CompatibleWithDifferentSearchSpaces {
    public UniformCrossover(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof GeneralString) && !(searchspace instanceof BitString)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        SearchSpace searchspace = this.graph.getSchedule().getGenotypeSearchSpace();
        int dimension = ((HasDimension)((Object)searchspace)).getDimension();
        RandomElement re = this.graph.getSchedule().getRandomElement();
        if (searchspace instanceof BitString) {
            BitSet bs1 = ((BitStringGenotype)ind1.getGenotype()).getBitSet();
            BitSet bs2 = ((BitStringGenotype)ind2.getGenotype()).getBitSet();
            BitSet bsOut = (BitSet)bs1.clone();
            int i = 0;
            while (i < dimension) {
                if (bs1.get(i) != bs2.get(i) && re.choose(2) == 1) {
                    bsOut.set(i, bs2.get(i));
                }
                ++i;
            }
            return new Individual(this.graph.getSchedule(), new BitStringGenotype(bsOut, dimension), new Individual[]{ind1, ind2});
        }
        int[] gs1 = ((GeneralStringGenotype)ind1.getGenotype()).getIntArray();
        int[] gs2 = ((GeneralStringGenotype)ind2.getGenotype()).getIntArray();
        int[] gsOut = (int[])gs1.clone();
        int numChars = ((GeneralString)searchspace).getNumChars();
        int i = 0;
        while (i < dimension) {
            if (gs1[i] != gs2[i] && re.choose(2) == 1) {
                gsOut[i] = gs2[i];
            }
            ++i;
        }
        return new Individual(this.graph.getSchedule(), new GeneralStringGenotype(gsOut, numChars), new Individual[]{ind1, ind2});
    }

    public String getDescription() {
        if (this.graph.getSchedule().getGenotypeSearchSpace() instanceof BitString) {
            return "Each bit is taken with probability 1/2 from the first parent and with probability 1/2 from the second parent.";
        }
        return "Each char is taken with probability 1/2 from the first parent and with probability 1/2 from the second parent.";
    }

    public String getName() {
        return "Uniform Crossover";
    }
}

