/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace;

import freak.core.population.Genotype;
import freak.module.searchspace.PointSet;

public class PointSetGenotype
extends Genotype {
    PointSet.Point[] m_kPoints;
    boolean[] m_kGivenSubSet;

    public PointSetGenotype(PointSet.Point[] pPoints, boolean[] pGivenSubSet) {
        this.m_kPoints = pPoints;
        this.m_kGivenSubSet = pGivenSubSet;
    }

    public void setSubSet(boolean[] selection) {
        this.m_kGivenSubSet = selection;
    }

    public PointSet.Point[] getPoints() {
        return this.m_kPoints;
    }

    public int getPointDimension() {
        return this.m_kPoints.length != 0 ? this.m_kPoints[0].getDimension() : -1;
    }

    public boolean[] getSubSet() {
        return (boolean[])this.m_kGivenSubSet.clone();
    }

    public PointSet.Point[] getChoosenSubSet() {
        int count = 0;
        int i = 0;
        while (i < this.m_kPoints.length) {
            if (this.m_kGivenSubSet[i]) {
                ++count;
            }
            ++i;
        }
        int j = 0;
        PointSet.Point[] result = new PointSet.Point[count];
        int i2 = 0;
        while (i2 < this.m_kPoints.length) {
            if (this.m_kGivenSubSet[i2]) {
                result[j++] = this.m_kPoints[i2];
            }
            ++i2;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PointSetGenotype)) {
            return false;
        }
        PointSetGenotype psg = (PointSetGenotype)o;
        return this.m_kPoints.equals(psg.m_kPoints) && this.m_kGivenSubSet.equals(psg.m_kGivenSubSet);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        String result = "[";
        int i = 0;
        while (i < this.m_kPoints.length - 1) {
            result = String.valueOf(result) + this.m_kPoints[i] + ", ";
            ++i;
        }
        result = String.valueOf(result) + this.m_kPoints[this.m_kPoints.length - 1] + "]\n[";
        i = 0;
        while (i < this.m_kGivenSubSet.length - 1) {
            if (this.m_kGivenSubSet[i]) {
                result = String.valueOf(result) + this.m_kPoints[i] + ", ";
            }
            ++i;
        }
        if (this.m_kGivenSubSet[this.m_kPoints.length - 1]) {
            result = String.valueOf(result) + this.m_kPoints[this.m_kPoints.length - 1];
        }
        result = String.valueOf(result) + "]";
        return result;
    }

    public Object clone() {
        PointSetGenotype copy;
        try {
            copy = (PointSetGenotype)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.toString());
        }
        copy.m_kPoints = (PointSet.Point[])this.m_kPoints.clone();
        copy.m_kGivenSubSet = (boolean[])this.m_kGivenSubSet.clone();
        return copy;
    }
}

