/*
 * Decompiled with CFR 0.152.
 */
package freak.module.mapper.generalstring;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.mapper.AbstractMapper;
import freak.core.population.Genotype;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class XOR_Mapper
extends AbstractMapper
implements BatchEventListener {
    private int[] addition;

    public XOR_Mapper(Schedule schedule) {
        super(schedule);
        if (schedule.getPhenotypeSearchSpace() instanceof GeneralString) {
            this.createAddition();
        }
    }

    public void initialize() {
        super.initialize();
        int dim = ((GeneralString)this.schedule.getPhenotypeSearchSpace()).getDimension();
        if (this.addition != null && this.addition.length != dim) {
            this.createAddition();
        }
    }

    public void createAddition() {
        GeneralString searchspace = (GeneralString)this.schedule.getPhenotypeSearchSpace();
        this.addition = ((GeneralStringGenotype)searchspace.getRandomGenotype()).getIntArray();
    }

    public Genotype genotypeToPhenotype(Genotype genotype) {
        GeneralString searchspace = (GeneralString)this.schedule.getPhenotypeSearchSpace();
        int dimension = searchspace.getDimension();
        int numChars = searchspace.getNumChars();
        int[] pheno = new int[dimension];
        int[] geno = ((GeneralStringGenotype)genotype).getIntArray();
        int i = 0;
        while (i < dimension) {
            pheno[i] = (geno[i] + this.addition[i]) % numChars;
            ++i;
        }
        return new GeneralStringGenotype(pheno, numChars);
    }

    public Genotype phenotypeToGenotype(Genotype genotype) {
        if (this.addition == null) {
            return genotype;
        }
        GeneralString searchspace = (GeneralString)this.schedule.getPhenotypeSearchSpace();
        int dimension = searchspace.getDimension();
        int numChars = searchspace.getNumChars();
        int[] geno = new int[dimension];
        int[] pheno = ((GeneralStringGenotype)genotype).getIntArray();
        int i = 0;
        while (i < dimension) {
            geno[i] = (pheno[i] - this.addition[i] + numChars) % numChars;
            ++i;
        }
        return new GeneralStringGenotype(geno, numChars);
    }

    public SearchSpace getGenotypeSearchSpace() {
        return this.schedule.getPhenotypeSearchSpace();
    }

    public String getName() {
        return "General String XOR";
    }

    public String getDescription() {
        return "(Value + RandomlyCreatedValue(0..., numChar-1)) % numChar";
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }

    public void batchStarted(BatchEvent evt) {
        this.createAddition();
    }
}

