/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.services;

import edu.ucsb.cs.jicos.foundation.Command;
import edu.ucsb.cs.jicos.foundation.Proxy;
import edu.ucsb.cs.jicos.foundation.RemoteExceptionHandler;
import edu.ucsb.cs.jicos.foundation.Service;
import edu.ucsb.cs.jicos.foundation.ServiceImpl;
import edu.ucsb.cs.jicos.foundation.ServiceName;
import edu.ucsb.cs.jicos.services.JicosRemoteExceptionHandler;
import edu.ucsb.cs.jicos.services.Point;
import edu.ucsb.cs.jicos.services.commands.LogoutClient;

public final class TaskServerProxy
extends Proxy {
    private static final long TERM = 10000L;
    private static final Command LOGOUT_CLIENT = new LogoutClient();
    private static final RemoteExceptionHandler REMOTE_EXCEPTION_HANDLER = new JicosRemoteExceptionHandler();
    private Service taskServer;
    private Point point;
    private boolean requestTasksPending = false;

    TaskServerProxy(ServiceName serviceName, ServiceImpl serviceImpl, RemoteExceptionHandler remoteExceptionHandler) {
        super(serviceName, serviceImpl, remoteExceptionHandler, 10000L);
        this.taskServer = serviceName.service();
        serviceImpl.addProxy(serviceName, this);
    }

    public void evict() {
        System.out.println("TaskServerProxy.evict: " + this.serviceName());
    }

    synchronized void point(Point point) {
        this.point = point;
    }

    synchronized Point point() {
        return this.point;
    }

    synchronized void receiveTasks() {
        this.requestTasksPending = false;
    }

    public synchronized boolean requestTasksPending() {
        if (this.requestTasksPending) {
            return true;
        }
        this.requestTasksPending = true;
        return false;
    }
}

