/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.control.Batch;
import freak.core.control.BatchList;
import freak.core.control.EventController;
import freak.core.control.EventInfo;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.graph.FreakGraphModel;
import freak.core.graph.GraphSyntaxException;
import freak.core.graph.Operator;
import freak.core.graph.OperatorGraph;
import freak.core.mapper.Mapper;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.IncompatibleModuleException;
import freak.core.modulesupport.IncompatibleModulePropertyException;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.ModuleCollector;
import freak.core.modulesupport.SpecificModuleRequiredException;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.Observer;
import freak.core.parametercontroller.ParameterController;
import freak.core.populationmanager.PopulationManager;
import freak.core.searchspace.SearchSpace;
import freak.core.stoppingcriterion.StoppingCriterion;
import freak.core.view.View;
import freak.gui.scheduleeditor.ScheduleEditor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class ScheduleDependencyChecker {
    private Schedule schedule;
    private ModuleCollector moduleCollector;
    private EventController eventController;
    private ScheduleEditor scheduleEditor;
    static boolean observerWarningAcknowledged = false;

    public ScheduleDependencyChecker(ScheduleEditor editor) {
        this.scheduleEditor = editor;
    }

    private List getObserversWithoutView() {
        List l = this.schedule.getObserverManager().getActiveObservers();
        ArrayList<Observer> resultList = new ArrayList<Observer>();
        for (Observer o : l) {
            if (!o.getViews().isEmpty()) continue;
            resultList.add(o);
        }
        return resultList;
    }

    private void updateDefaultBatch() {
        Configuration config;
        Configurable confObj;
        Batch batch = this.schedule.getDefaultBatch();
        if (this.schedule.getPhenotypeSearchSpace() instanceof Configurable) {
            confObj = (Configurable)((Object)this.schedule.getPhenotypeSearchSpace());
            config = confObj.getConfiguration();
            batch.putConfiguration(confObj, config);
        }
        if (this.schedule.getRealFitnessFunction() instanceof Configurable) {
            confObj = (Configurable)((Object)this.schedule.getRealFitnessFunction());
            config = confObj.getConfiguration();
            batch.putConfiguration(confObj, config);
        }
        if (this.schedule.getInitialization() instanceof Configurable) {
            confObj = this.schedule.getInitialization();
            config = confObj.getConfiguration();
            batch.putConfiguration(confObj, config);
        }
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
        this.eventController = schedule.getEventController();
        this.moduleCollector = new ModuleCollector(schedule);
    }

    public boolean isObserverSetupOk() {
        if (!observerWarningAcknowledged) {
            if (this.schedule.getObserverManager().getActiveObservers().isEmpty()) {
                boolean answer;
                observerWarningAcknowledged = answer = JOptionPane.showConfirmDialog(null, "Please note, that you don't have any observers in your schedule.\nYou won't see anything while your algorithm runs.\n\nDo you want to continue?", "No Observers found", 0) == 0;
                return answer;
            }
            List l = this.getObserversWithoutView();
            if (!l.isEmpty()) {
                boolean answer;
                String obs = "";
                for (Observer o : l) {
                    obs = String.valueOf(obs) + " - " + o.getName() + "\n";
                }
                observerWarningAcknowledged = answer = JOptionPane.showConfirmDialog(null, "The following observers don't have any view attached. You won't see any result of these observers:\n\n" + obs + "\nDo you want to continue?", "No View for Observers", 0) == 0;
                return answer;
            }
        }
        return true;
    }

    public boolean isGraphCorrect() {
        try {
            this.schedule.getOperatorGraph().checkSyntax();
            return true;
        }
        catch (GraphSyntaxException e) {
            JOptionPane.showMessageDialog(null, "Your graph has syntax errors. You have to correct the graph first.");
            return false;
        }
    }

    public boolean isEventSetupCorrect() {
        if (!this.eventController.allEventsRegistered()) {
            List l = this.eventController.getUnregisteredEvents();
            String msg = "The following events have not yet been assigned.\n\n";
            for (EventInfo evt : l) {
                String moduleName = evt.getOwner() instanceof Module ? ((Module)((Object)evt.getOwner())).getName() : evt.getOwner().toString();
                msg = String.valueOf(msg) + " - " + moduleName + " (" + evt.getEventName() + ")\n";
            }
            msg = String.valueOf(msg) + "\nRunning such a schedule will not make sense.\nYou have to assign proper event sources to these events before you can continue.";
            JOptionPane.showMessageDialog(null, msg);
            return false;
        }
        return true;
    }

    public boolean isCorrect() {
        return this.isEventSetupCorrect() && this.isObserverSetupOk() && this.isGraphCorrect();
    }

    public boolean isComplete() {
        return this.schedule.getGenotypeSearchSpace() != null && this.schedule.getFitnessFunction() != null && this.schedule.getOperatorGraph() != null && this.schedule.getStoppingCriteria() != null && this.schedule.getInitialization() != null && this.schedule.getPopulationManager() != null && this.schedule.getOperatorGraph() != null && !this.schedule.getOperatorGraph().isEmpty();
    }

    public void createDefaultBatch() {
        this.schedule.setDefaultBatch(this.schedule.createBatchFromCurrentConfigurations());
    }

    public void createDefaultBatchList() {
        BatchList batchList = this.schedule.getBatchList();
        batchList.clear();
        batchList.add(this.schedule.getDefaultBatch().copy(), true);
    }

    private void clearBatchList() {
        BatchList batchList = this.schedule.getBatchList();
        batchList.clear();
    }

    public void createDefaultOperatorGraph() {
        FreakGraphModel operatorGraph = new FreakGraphModel(this.schedule);
        operatorGraph.getOperatorGraph().createEvents();
        this.schedule.setGraphModel(operatorGraph);
    }

    public void processNewSearchSpace() {
        this.checkCurrentSchedule(false);
        this.schedule.callInitialize();
        this.createDefaultBatch();
        this.clearBatchList();
    }

    public void processNewFitnessFunction() {
        this.checkCurrentSchedule(false);
        this.schedule.callInitialize();
        this.createDefaultBatch();
        this.clearBatchList();
    }

    public void processNewMapper() {
        this.checkCurrentSchedule(false);
        this.schedule.callInitialize();
    }

    public void processNewGraph() {
        this.checkCurrentSchedule(false);
        this.schedule.callInitialize();
    }

    public void processNewStoppingCriterion() {
        this.checkCurrentSchedule(false);
        this.schedule.callInitialize();
    }

    public void processNewPopulationManager() {
        this.checkCurrentSchedule(false);
        this.schedule.callInitialize();
    }

    public void processNewInitializationOperator() {
        this.checkCurrentSchedule(false);
        this.schedule.callInitialize();
        this.createDefaultBatch();
        this.clearBatchList();
    }

    public void processNewModuleConfiguration(Module module) {
        this.updateDefaultBatch();
        this.checkCurrentSchedule(true);
        this.schedule.callInitialize();
    }

    public void removeFitnessFunction() {
        this.eventController.removeAllOfClass(FitnessFunction.class);
        this.schedule.setFitnessFunction(null);
    }

    public void removeMapper() {
        this.eventController.removeAllOfClass(Mapper.class);
        this.schedule.setMapper(null);
    }

    public void removeGraph() {
        if (this.schedule.getOperatorGraph() != null) {
            this.schedule.getOperatorGraph().removeFromEventController();
            this.schedule.setGraphModel(null);
        }
    }

    private void removeModuleFromSchedule(Module module) {
        this.eventController.removeModule(module);
        if (module instanceof SearchSpace) {
            this.schedule.setPhenotypeSearchSpace(null);
        } else if (module instanceof FitnessFunction) {
            this.removeFitnessFunction();
        } else if (module instanceof Mapper) {
            this.removeMapper();
        } else if (module instanceof OperatorGraph || module instanceof Operator && module != this.schedule.getInitialization() || module instanceof ParameterController) {
            this.removeGraph();
        } else if (module instanceof PopulationManager) {
            this.schedule.setPopulationManager(null);
        } else if (module instanceof StoppingCriterion) {
            StoppingCriterion[] stoppingCriteria = this.schedule.getStoppingCriteria();
            if (stoppingCriteria != null && stoppingCriteria.length > 0) {
                StoppingCriterion[] newCriteria = new StoppingCriterion[stoppingCriteria.length - 1];
                System.arraycopy(stoppingCriteria, 0, newCriteria, 0, newCriteria.length);
                int i = 0;
                while (i < newCriteria.length) {
                    if (newCriteria[i] == module) {
                        newCriteria[i] = stoppingCriteria[stoppingCriteria.length - 1];
                    }
                    ++i;
                }
                this.schedule.setStoppingCriteria(newCriteria);
            }
        } else if (module == this.schedule.getInitialization()) {
            this.schedule.setInitialization(null);
        } else if (module instanceof Observer) {
            View[] views = ((Observer)module).getViews().toArray(new View[((Observer)module).getViews().size()]);
            int i = 0;
            while (i < views.length) {
                this.removeModuleFromSchedule(views[i]);
                ++i;
            }
            this.schedule.getObserverManager().removeObserver((Observer)module);
        } else if (module instanceof View) {
            Observer observer = ((View)module).getObserver();
            if (observer != null) {
                observer.removeView((View)module);
            }
        } else {
            throw new RuntimeException("Unkown module class: " + module);
        }
    }

    protected void checkCurrentSchedule(boolean showWarnings) {
        for (Module module : this.schedule.getAllModules()) {
            try {
                this.checkModule(module, showWarnings);
            }
            catch (Exception e) {
                this.processIncompatibleModule(module);
                this.checkCurrentSchedule(showWarnings);
                break;
            }
        }
    }

    private void processIncompatibleModule(Module module) {
        if (module == this.schedule.getPhenotypeSearchSpace()) {
            this.removeModuleFromSchedule(module);
            this.processNewSearchSpace();
        } else if (module == this.schedule.getMapper()) {
            this.removeModuleFromSchedule(module);
            this.processNewMapper();
        } else {
            this.removeModuleFromSchedule(module);
        }
        this.scheduleEditor.updateComponents();
    }

    protected void checkModule(Module module, boolean showWarnings) throws UnsupportedEnvironmentException {
        try {
            this.moduleCollector.checkPackageOfModule(module);
            module.testSchedule(this.schedule);
        }
        catch (IncompatibleModulePropertyException e) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(this.scheduleEditor, "Module " + module.getName() + " is not compatible with property " + e.getProperty() + " of module " + e.getModule().getName() + ".", "Incompatible module property", 0);
            }
            throw e;
        }
        catch (IncompatibleModuleException e) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(this.scheduleEditor, "Module " + module.getName() + " is not compatible with module " + e.getModule().getName() + ".", "Incompatible modules", 0);
            }
            throw e;
        }
        catch (SpecificModuleRequiredException e) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(this.scheduleEditor, "Module " + module.getName() + " requires an instance of " + e.getModuleClass() + " to run.", "Specific module required", 0);
            }
            throw e;
        }
        catch (UnsupportedEnvironmentException e) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(this.scheduleEditor, "Module " + module.getName() + " cannot be used within the current schedule.", "Incompatible module", 0);
            }
            throw e;
        }
    }
}

