/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.view.SingleIndividualView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.fitness.generalstring.IsingModelTorus;
import freak.module.searchspace.GeneralString;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class IsingModelTorusView
extends SingleIndividualView
implements Configurable,
FreakSwingModel {
    private static final float MAXIMAL_HUE = 0.8f;
    private static float SATURATION = 1.0f;
    private static float BRIGHTNESS = 1.0f;
    private boolean showGrid = true;

    public IsingModelTorusView(Schedule schedule) {
        super(schedule);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getRealFitnessFunction() instanceof IsingModelTorus)) {
            throw new UnsupportedEnvironmentException("Does only work with the fitness IsingModelTorus");
        }
    }

    public JPanel createIndividualPanel() {
        return new TorusPanel(this);
    }

    public String getName() {
        return "Ising Model Torus";
    }

    public String getDescription() {
        return "Shows the nodes of the Ising Model torus.";
    }

    public void setPropertyShowGrid(Boolean b) {
        this.showGrid = b;
        UpdateManager.markDirty(this);
    }

    public Boolean getPropertyShowGrid() {
        return new Boolean(this.showGrid);
    }

    public String getShortDescriptionForShowGrid() {
        return "Show grid";
    }

    public String getLongDescriptionForShowGrid() {
        return "If set, a grid of black lines is drawn.";
    }

    class TorusPanel
    extends JPanel {
        private Insets insets;
        private int currentWidth;
        private int currentHeight;
        private Graphics graphics;
        private IsingModelTorusView view;
        private int torusWidth;
        private int torusHeight;
        private Rectangle[][] fields;

        public TorusPanel(IsingModelTorusView view) {
            this.view = view;
            this.setOpaque(true);
            IsingModelTorus ising = (IsingModelTorus)IsingModelTorusView.this.getSchedule().getRealFitnessFunction();
            this.torusWidth = ising.getPropertyTorusWidth();
            this.torusHeight = ising.getPropertyTorusHeight();
        }

        private void cacheRectangles() {
            this.fields = new Rectangle[this.torusWidth][this.torusHeight];
            int y = 0;
            while (y < this.torusHeight) {
                int x = 0;
                while (x < this.torusWidth) {
                    this.fields[x][y] = this.getField(x, y);
                    ++x;
                }
                ++y;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.graphics = g;
            int oldCurrentWidth = this.currentWidth;
            int oldCurrentHeight = this.currentHeight;
            this.insets = this.getInsets();
            this.currentWidth = this.getWidth() - this.insets.left - this.insets.right;
            this.currentHeight = this.getHeight() - this.insets.top - this.insets.bottom;
            if (this.fields == null || oldCurrentWidth != this.currentWidth || oldCurrentHeight != this.currentHeight) {
                this.cacheRectangles();
            }
            IsingModelTorus ising = (IsingModelTorus)IsingModelTorusView.this.getSchedule().getRealFitnessFunction();
            IsingModelTorusView isingModelTorusView = this.view;
            synchronized (isingModelTorusView) {
                Individual individual = IsingModelTorusView.this.getIndividualToDisplay();
                if (individual != null) {
                    boolean drawGrid = IsingModelTorusView.this.showGrid && this.getField((int)0, (int)0).width > 3 && this.getField((int)0, (int)0).height > 3;
                    Color[] colors = new Color[((GeneralString)IsingModelTorusView.this.getSchedule().getGenotypeSearchSpace()).getPropertyNumberOfChars().intValue()];
                    int i = 0;
                    while (i < colors.length) {
                        colors[i] = this.getColor(i);
                        ++i;
                    }
                    int y = 0;
                    while (y < this.torusHeight) {
                        int x = 0;
                        while (x < this.torusWidth) {
                            Rectangle rect = this.fields[x][y];
                            if (drawGrid) {
                                this.graphics.setColor(Color.black);
                                this.graphics.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                                this.graphics.setColor(this.getColor(ising.torusValue(individual, x, y)));
                                this.graphics.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                            } else {
                                this.graphics.setColor(colors[ising.torusValue(individual, x, y)]);
                                this.graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                            }
                            ++x;
                        }
                        ++y;
                    }
                }
            }
        }

        private Color getColor(int value) {
            int k = ((GeneralString)IsingModelTorusView.this.getSchedule().getGenotypeSearchSpace()).getPropertyNumberOfChars();
            return new Color(Color.HSBtoRGB((float)value / (float)k * 0.8f, SATURATION, BRIGHTNESS));
        }

        private Rectangle getField(int j, int i) {
            int x = this.currentWidth * j / this.torusWidth;
            int y = this.currentHeight * i / this.torusHeight;
            return new Rectangle(x, y, this.currentWidth * (j + 1) / this.torusWidth - x, this.currentHeight * (i + 1) / this.torusHeight - y);
        }
    }
}

