/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.generalstring;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.Mutation;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.core.util.FreakMath;
import freak.module.fitness.generalstring.IsingModelCliques;
import freak.module.searchspace.GeneralStringGenotype;

public class CliqueMutation
extends Mutation
implements Configurable {
    private int k = 1;

    public CliqueMutation(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        if (!(schedule.getRealFitnessFunction() instanceof IsingModelCliques)) {
            throw new UnsupportedEnvironmentException("Works only with IsingModelCliques.");
        }
    }

    protected Individual doMutation(Individual ind) {
        IsingModelCliques.Clique[] cliques = ((IsingModelCliques)this.getOperatorGraph().getSchedule().getRealFitnessFunction()).getCliques();
        Genotype gt = ind.getGenotype();
        GeneralStringGenotype geno = (GeneralStringGenotype)((GeneralStringGenotype)gt).clone();
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int j = 0;
        while (j < cliques.length) {
            int[] flippos = FreakMath.getKofN(this.graph.getSchedule(), this.k, cliques[j].getSize());
            int i = 0;
            while (i < this.k) {
                geno.flip(flippos[i] + cliques[j].getStart(), re);
                ++i;
            }
            ++j;
        }
        return new Individual(this.graph.getSchedule(), geno, new Individual[]{ind});
    }

    public void setPropertyK(Integer num) {
        if (num >= 0 && num <= ((HasDimension)((Object)this.getGenotypeSearchSpace())).getDimension()) {
            this.k = num;
        }
    }

    public Integer getPropertyK() {
        return new Integer(this.k);
    }

    public String getLongDescriptionForkK() {
        return "Number of positions to alter in each clique.";
    }

    public String getShortDescriptionForK() {
        return "k";
    }

    public String getDescription() {
        return "Exactly k randomly chosen positions are altered within each clique. Altering a position means that a character randomly chosen among the remaining characters is assigned to this position.";
    }

    public String getName() {
        return "Clique Mutation";
    }
}

