/*
 * Decompiled with CFR 0.152.
 */
package freak.core.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.stoppingcriterion.AbstractStoppingCriterion;

public abstract class AbstractGenerationStoppingCriterion
extends AbstractStoppingCriterion
implements Configurable,
GenerationEventListener {
    private int numGen = 1;

    public AbstractGenerationStoppingCriterion(Schedule schedule) {
        super(schedule);
    }

    public void setPropertyNumberGenerations(Integer num) {
        if (num > 0) {
            this.numGen = num;
        }
    }

    public Integer getPropertyNumberGenerations() {
        return new Integer(this.numGen);
    }

    public String getShortDescriptionForNumberGenerations() {
        return "Period of checks";
    }

    public String getLongDescriptionForNumberGenerations() {
        return "The period specifying when the stopping criterion is checked in generations.";
    }

    public void generation(GenerationEvent evt) {
        if (evt.getNumber() % this.numGen == 0) {
            this.checkCriterion(evt);
        }
    }

    public void createEvents() {
        this.getSchedule().getEventController().addEvent((EventListener)this, GenerationEvent.class, this.getSchedule());
    }

    protected abstract void checkCriterion(GenerationEvent var1);
}

