/*
 * Decompiled with CFR 0.152.
 */
package javalain.ea;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.ObjectiveComparator;
import javalain.math.fonction.Fct;

public class EnsembleSolutionEA {
    protected ArrayList<SolutionEA> liste;
    private Fct fct;

    public EnsembleSolutionEA(Fct pFct) {
        this(10, pFct);
    }

    public EnsembleSolutionEA(int pTaille, Fct pFct) {
        this.liste = new ArrayList(pTaille);
        this.fct = pFct;
    }

    public int size() {
        return this.liste.size();
    }

    public void clear() {
        this.liste.clear();
    }

    public boolean add(SolutionEA s) {
        this.liste.add(s);
        return true;
    }

    public SolutionEA get(int i) {
        return this.liste.get(i);
    }

    public Iterator<SolutionEA> iterator() {
        return this.liste.iterator();
    }

    public EnsembleSolutionEA union(EnsembleSolutionEA ensb) {
        int i;
        if (!this.fct.equals(ensb.fct)) {
            throw new IllegalArgumentException("EnsembleSolutionEA, union (EnsembleSolutionEA) : ensembles de solutions de probl\u00e8mes diff\u00e9rents : " + this.fct.getNomFct() + " et " + ensb.fct.getNomFct() + ".");
        }
        EnsembleSolutionEA union = new EnsembleSolutionEA(this.size() + ensb.size(), this.fct);
        for (i = 0; i < this.size(); ++i) {
            union.add(this.get(i));
        }
        for (i = 0; i < ensb.size(); ++i) {
            union.add(ensb.get(i));
        }
        return union;
    }

    public double[][] toMatriceObjectif() {
        if (this.liste.isEmpty()) {
            return null;
        }
        int nbObj = this.liste.get(0).getObjectif().length;
        double[][] tab = new double[this.liste.size()][nbObj];
        for (int i = 0; i < this.liste.size(); ++i) {
            System.arraycopy(this.liste.get(i).getObjectif(), 0, tab[i], 0, nbObj);
        }
        return tab;
    }

    public void crowdingDistance() {
        int size = this.liste.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            this.liste.get(0).setCrowdingDistance(Double.POSITIVE_INFINITY);
            return;
        }
        if (size == 2) {
            this.liste.get(0).setCrowdingDistance(Double.POSITIVE_INFINITY);
            this.liste.get(1).setCrowdingDistance(Double.POSITIVE_INFINITY);
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.liste.get(i).setCrowdingDistance(0.0);
        }
        for (int i = 0; i < this.fct.getNbFctObjectif(); ++i) {
            Collections.sort(this.liste, new ObjectiveComparator(i));
            double etendueObj = this.liste.get(this.liste.size() - 1).getObjectif()[i] - this.liste.get(0).getObjectif()[i];
            this.liste.get(0).setCrowdingDistance(Double.POSITIVE_INFINITY);
            this.liste.get(size - 1).setCrowdingDistance(Double.POSITIVE_INFINITY);
            for (int j = 1; j < size - 1; ++j) {
                double distance = this.liste.get(j + 1).getObjectif()[i] - this.liste.get(j - 1).getObjectif()[i];
                distance /= etendueObj;
                this.liste.get(j).setCrowdingDistance(distance += this.liste.get(j).getCrowdingDistance());
            }
        }
    }

    public void sort(Comparator<SolutionEA> comp) {
        Collections.sort(this.liste, comp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(">---> ").append(this.fct.getNomFct()).append(" - nombre de solutions=").append(this.liste.size()).append(", (x1...xn) n=").append(this.liste.get(0).getVariable().length).append(", (f1...fm) m=").append(this.liste.get(0).getObjectif().length).append("\n");
        for (int i = 0; i < this.liste.size(); ++i) {
            sb.append(this.liste.get(i).toString()).append('\n');
        }
        sb.append("<---< (Fin)");
        return sb.toString();
    }
}

