/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents.eventlist;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoublyLinked
implements EventList {
    private int modCount = 0;
    private Node first = null;
    private Node last = null;
    private static Node free = null;

    @Override
    public boolean isEmpty() {
        return this.first == null;
    }

    @Override
    public void clear() {
        if (this.first == null) {
            return;
        }
        this.last.succ = free;
        free = this.first;
        this.first = null;
        this.last = null;
        ++this.modCount;
    }

    @Override
    public void add(Event event) {
        Node node;
        if (free == null) {
            node = new Node();
        } else {
            node = free;
            free = DoublyLinked.free.succ;
        }
        node.ev = event;
        ++this.modCount;
        if (this.last == null) {
            this.first = this.last = node;
            this.first.succ = null;
            this.first.prec = null;
            return;
        }
        Node node2 = this.findPosition(event);
        if (node2 == null) {
            node.succ = this.first;
            node.succ.prec = node;
            this.first = node;
            node.prec = null;
        } else {
            node.prec = node2;
            node.succ = node2.succ;
            node2.succ = node;
            if (node.succ != null) {
                node.succ.prec = node;
            } else {
                this.last = node;
            }
        }
    }

    @Override
    public void addFirst(Event event) {
        Node node;
        if (free == null) {
            node = new Node();
        } else {
            node = free;
            free = DoublyLinked.free.succ;
        }
        node.ev = event;
        node.prec = null;
        if (this.first == null) {
            this.first = this.last = node;
            this.first.succ = null;
        } else {
            node.succ = this.first;
            this.first.prec = node;
            this.first = node;
        }
        ++this.modCount;
    }

    @Override
    public void addBefore(Event event, Event event2) {
        Node node;
        Node node2 = this.last;
        while (node2 != null && node2.ev.time() >= event2.time() && node2.ev != event2) {
            node2 = node2.prec;
        }
        if (node2.ev != event2) {
            throw new IllegalArgumentException("Event not in list.");
        }
        if (free == null) {
            node = new Node();
        } else {
            node = free;
            free = DoublyLinked.free.succ;
        }
        node.ev = event;
        node.prec = node2.prec;
        node.succ = node2;
        node2.prec = node;
        if (node.prec != null) {
            node.prec.succ = node;
        } else {
            this.first = node;
        }
        ++this.modCount;
    }

    @Override
    public void addAfter(Event event, Event event2) {
        Node node;
        Node node2 = this.last;
        while (node2 != null && node2.ev.time() >= event2.time() && node2.ev != event2) {
            node2 = node2.prec;
        }
        if (node2.ev != event2) {
            throw new IllegalArgumentException("Event not in list.");
        }
        if (free == null) {
            node = new Node();
        } else {
            node = free;
            free = DoublyLinked.free.succ;
        }
        node.ev = event;
        node.prec = node2;
        node.succ = node2.succ;
        node2.succ = node;
        if (node.succ != null) {
            node.succ.prec = node;
        } else {
            this.last = node;
        }
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        return this.first == null ? null : this.first.ev;
    }

    @Override
    public Event getFirstOfClass(String string) {
        Node node = this.first;
        while (node != null) {
            if (node.ev.getClass().getName().equals(string)) {
                return node.ev;
            }
            node = node.succ;
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> clazz) {
        Node node = this.first;
        while (node != null) {
            if (node.ev.getClass() == clazz) {
                return (E)node.ev;
            }
            node = node.succ;
        }
        return null;
    }

    @Override
    public boolean remove(Event event) {
        Node node = this.last;
        while (node != null && node.ev.time() >= event.time() && node.ev != event) {
            node = node.prec;
        }
        if (node == null || node.ev != event) {
            return false;
        }
        if (node == this.last && node == this.first) {
            this.first = null;
            this.last = null;
        } else {
            if (node == this.last) {
                this.last = node.prec;
                this.last.succ = null;
            } else {
                node.succ.prec = node.prec;
            }
            if (node == this.first) {
                this.first = node.succ;
                this.first.prec = null;
            } else {
                node.prec.succ = node.succ;
                node.prec = null;
            }
        }
        node.ev = null;
        node.succ = free;
        free = node;
        ++this.modCount;
        return true;
    }

    @Override
    public Event removeFirst() {
        if (this.first == null) {
            return null;
        }
        Event event = this.first.ev;
        Node node = this.first;
        this.first = this.first.succ;
        if (this.first == null) {
            this.last = null;
        } else {
            this.first.prec = null;
        }
        node.ev = null;
        node.succ = free;
        free = node;
        ++this.modCount;
        return event;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new DLItr();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Contents of the event list DoublyLinked :");
        Node node = this.first;
        while (node != null) {
            stringBuffer.append("\n" + PrintfFormat.g(8, 4, node.ev.time()) + " : " + node.ev.toString());
            node = node.succ;
        }
        return stringBuffer.toString();
    }

    private Node findPosition(Event event) {
        Node node = this.last;
        double d = 0.0;
        double d2 = 0.0;
        d = event.time();
        if (this.last != null) {
            d2 = this.last.ev.time();
        }
        while (node != null && d2 > d) {
            node = node.prec;
            if (node == null) continue;
            d2 = node.ev.time();
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DLItr
    implements ListIterator<Event> {
        private Node prev = null;
        private Node next;
        private Node lastRet;
        private int expectedModCount;
        private int nextIndex;

        DLItr() {
            this.next = DoublyLinked.this.first;
            this.expectedModCount = DoublyLinked.this.modCount;
            this.lastRet = null;
            this.nextIndex = 0;
        }

        @Override
        public void add(Event event) {
            Node node;
            if (DoublyLinked.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next != null && event.time() > this.next.ev.time()) {
                event.setTime(this.next.ev.time());
            }
            if (this.prev != null && event.time() < this.prev.ev.time()) {
                event.setTime(this.prev.ev.time());
            }
            if (free == null) {
                node = new Node();
            } else {
                node = free;
                free = free.succ;
            }
            node.ev = event;
            ++this.nextIndex;
            ++DoublyLinked.this.modCount;
            ++this.expectedModCount;
            this.lastRet = null;
            if (DoublyLinked.this.last == null) {
                DoublyLinked.this.first = (DoublyLinked.this.last = node);
                ((DoublyLinked)DoublyLinked.this).first.succ = null;
                ((DoublyLinked)DoublyLinked.this).first.prec = null;
                this.prev = node;
                this.next = null;
                this.nextIndex = 1;
            } else if (this.prev == null) {
                node.succ = DoublyLinked.this.first;
                node.succ.prec = node;
                DoublyLinked.this.first = node;
                node.prec = null;
                this.prev = node;
            } else {
                node.prec = this.prev;
                node.succ = this.next;
                this.prev.succ = node;
                if (node.succ != null) {
                    node.succ.prec = node;
                } else {
                    DoublyLinked.this.last = node;
                }
                this.prev = node;
            }
        }

        @Override
        public boolean hasNext() {
            if (DoublyLinked.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            if (DoublyLinked.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.prev != null;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event event = this.next.ev;
            this.lastRet = this.next;
            this.prev = this.next;
            this.next = this.next.succ;
            return event;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event event = this.prev.ev;
            this.lastRet = this.prev;
            this.next = this.prev;
            this.prev = this.prev.prec;
            return event;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (DoublyLinked.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet == this.next) {
                this.next = this.next.succ;
            } else {
                this.prev = this.prev.prec;
                --this.nextIndex;
            }
            if (this.lastRet == DoublyLinked.this.last && this.lastRet == DoublyLinked.this.first) {
                DoublyLinked.this.last = (DoublyLinked.this.first = null);
                this.prev = null;
                this.next = null;
            } else {
                if (this.lastRet == DoublyLinked.this.last) {
                    DoublyLinked.this.last = this.lastRet.prec;
                    ((DoublyLinked)DoublyLinked.this).last.succ = null;
                } else {
                    this.lastRet.succ.prec = this.lastRet.prec;
                }
                if (this.lastRet == DoublyLinked.this.first) {
                    DoublyLinked.this.first = this.lastRet.succ;
                    ((DoublyLinked)DoublyLinked.this).first.prec = null;
                } else {
                    this.lastRet.prec.succ = this.lastRet.succ;
                    this.lastRet.prec = null;
                }
            }
            this.lastRet.ev = null;
            this.lastRet.succ = free;
            free = this.lastRet;
            this.lastRet = null;
            ++DoublyLinked.this.modCount;
            ++this.expectedModCount;
        }

        @Override
        public void set(Event event) {
            if (DoublyLinked.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet.prec != null && event.time() < this.lastRet.prec.ev.time()) {
                event.setTime(this.lastRet.prec.ev.time());
            }
            if (this.lastRet.succ != null && event.time() > this.lastRet.succ.ev.time()) {
                event.setTime(this.lastRet.succ.ev.time());
            }
            this.lastRet.ev = event;
        }
    }

    private static class Node {
        Event ev;
        Node prec;
        Node succ;

        private Node() {
        }
    }
}

