% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_r_data_package.R
\name{build_r_data_package}
\alias{build_r_data_package}
\alias{build_r_data_package.rcer_rccore}
\alias{build_r_data_package.default}
\title{Build R Data Package}
\usage{
build_r_data_package(x, ...)

\method{build_r_data_package}{rcer_rccore}(x, path = NULL, author_roles = NULL, verbose = TRUE, ...)

\method{build_r_data_package}{default}(
  x,
  uri = NULL,
  token = NULL,
  format = NULL,
  path = NULL,
  author_roles = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{rcer_rccore} object}

\item{...}{arguments passed to \code{\link{format_record}}}

\item{path}{Path where the exported project source will be
created/overwritten.}

\item{author_roles}{a list naming specific roles for each user id found in
the user table from an exported project.  By default all users with be
contributors ('ctb').  You will need to define a author/creator.}

\item{verbose}{provide messages to tell the user what is happening}

\item{uri}{The URI for the REDCap API.  If \code{NULL} (default) the value
\code{Sys.getenv("REDCap_API_URI")} is used.}

\item{token}{The API token for the project you want to export from. If
\code{NULL} (default) the value \code{Sys.getenv("REDCap_API_TOKEN")} is
used.}

\item{format}{The format to return. If \code{NULL} (default) the value
\code{Sys.getenv("REDCap_API_format")} is used.}
}
\description{
Build a R Data Package from the core contents of a REDCap Project.
}
\details{
To export the data from a REDCap project you will need to have an API Token.
Remember, the token is the equivalent of a username and password.  As such
you should not list the token in plan text.  Several alternative methods for
passing the token to this method will be provided in examples and vignettes.
We strongly encourage the use of the package secret
\url{https://cran.r-project.org/package=secret} to build vaults to store
tokens locally.

The initial export will consist of four pieces of data, the user data,
metadata, project info, and records.
}
\examples{
## Please read the vignette for examples:
## vignette(topic = "export", package = "REDCapExporter")

library(REDCapExporter)
# avs_raw_core <- export_core()
data(avs_raw_core)
tmppth <- tempdir()
build_r_data_package(avs_raw_core, tmppth, author_roles = list(dewittp = c("cre", "aut")))
fs::dir_tree(tmppth)

}
