% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap_data.R
\name{redcap_data}
\alias{redcap_data}
\title{Read REDCap data}
\usage{
redcap_data(data_path = NA, dic_path = NA, uri = NA, token = NA)
}
\arguments{
\item{data_path}{Character string with the pathname of the R file to read the dataset from.}

\item{dic_path}{Character string with the pathname of the dictionary.}

\item{uri}{The URI (uniform resource identifier) of the REDCap project.}

\item{token}{Character vector with the code of the token.}
}
\value{
List with the dataset and the dictionary of the corresponding REDCap project.
}
\description{
This function allows you to read datasets from REDCap through exported data or API.

The REDCap API is an interface that allows communication with REDCap and server without going through the interactive REDCap interface.

If you will give further use to the package, we advise you to use the argument 'dic_path' to read your dictionary, since all other functions need it in order to run properly.
}
\note{
To read exported data you have to first use REDCap's 'Export Data' function and select the format 'R Statistical Software', then it will generate one CSV file with all observations and an R file with the necessary code to complete each variable information.
}
