\name{dieharder}
\alias{dieharder}
\alias{dieharder.default}
\alias{print.dieharder}
\alias{plot.dieharder}
\alias{summary.dieharder}
\alias{dieharderGenerators}
\alias{dieharderTests}
\title{Random numebr generator test suite}
\description{
  The \code{random} package provides an interface to the dieharder suite
  of random number generators.
}
\usage{
   \method{dieharder}{default}(rng="mt19937", test="diehard_runs", psamples=100,
                               seed=0, verbose=FALSE, inputfile="", ntuple=5) 
   \method{print}{dieharder}(x, ...)
   \method{summary}{dieharder}(object, ...)
   \method{plot}{dieharder}(x, ...)
   dieharderGenerators()
   dieharderTests()
}
\arguments{
  \item{rng}{Either a single character vector, or an integer index,
    selecting a random-number generator to be tested.}
  \item{test}{Either a single character vector, or an integer index,
    selecting a dieharder test to be used.}
  \item{psamples}{An integer for the number of probability values samples
    underlying the main Kolomogorov-Smirnov test.}
  \item{seed}{An integer seed that is to be used for the dieharder rng;
    if 0, a new random seed is generated.}
  \item{verbose}{A switch selecting verbose or silent operation.}
  \item{inputfile}{File to read rng draws from for the \code{file_input} and
    \code{file_input_raw} generators.}
  \item{ntuple}{A integer selecting the ntuple length for tests on short
    bit strings that permit varying length such as RGB bitdist.}
  \item{x}{A dieharder object.}
  \item{object}{A dieharder object.}
  \item{...}{Other arguments passed on.}
}
\value{
  An object of class \code{dieharder}, which inherits from the class
  \code{htest} commonly used for test statistics is returned. It
  contains the members
  \item{p.value}{for the (Kuiper variant) of the Kolmogorov-Smirnov test
    of the null of a uniform distribution of test values generated by
    \code{psamples} tests of \code{test} using draws from \code{rng}}
  \item{data}{the vector of test statistics used for the
    Kolmogorov-Smirnov test}
  \item{method}{the test method as returned by the \code{dieharder}
    library}
  \item{data.name}{a character vector describing the data}
  \item{generator}{a text desciption of the generator as returned by the
    \code{dieharder} library}
} \details{
  The current list of generators can be generated dynamically
  using the \code{dieharderGenerators()} function.  Entries with
  \code{id} below 200 are from the GNU Scientific Library, entries with
  \code{id} greater or equal to 200 and less than 400 are from Dieharder itself,
  entries with \code{id} greater or equal to 400 and less than 500 are from GNU R,
  entries with \code{id} greater or equal to 500 and less than 600 are
  hardware-based (which is system-dependent), and entries with 
  \code{id} greater or equal to 600 are user-contributed.

  The current list of tests can be generated dynamicall using the
  \code{dieharderTests()} function.
}
\references{
  The \code{dieharder} source code and website
  at \url{http://www.phy.duke.edu/~rgb/General/dieharder.php}.
}
\author{Dirk Eddelbuettel \email{edd@debian.org} for the
  \R interface and the port of the R RNGs to DieHarder; Robert G. Brown
  for everything else in \code{dieharder}. 
}
\examples{
  ## need to set this for the example to pass the R CMD check test
  .dieharder.generators <<- dieharderGenerators()
  dh <- dieharder(41, 15, seed=12345) # randu and diehard_runs
  dh
  summary(dh)
  plot(dh)
}
\keyword{misc}
