% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-degree.R
\name{impute.degree}
\alias{impute.degree}
\title{Imputes missing degree values}
\usage{
impute.degree(
  rds.data,
  trait.variable = NULL,
  N = NULL,
  method = c("mean", "quantile"),
  quantile = 0.5,
  recruitment.lower.bound = TRUE,
  round.degree = TRUE
)
}
\arguments{
\item{rds.data}{an rds.data.frame}

\item{trait.variable}{the name of the variable in rds.data to stratify the imputation by}

\item{N}{population size}

\item{method}{If mean, the weighted mean value is imputed, otherwize a quantile is used.}

\item{quantile}{If method is "quantile", this is the quantile that is used. Defaults to median}

\item{recruitment.lower.bound}{If TRUE, then for each individual, the degree is taken to be the minimum of
the number of recruits plus one, and the reported degree}

\item{round.degree}{Should degrees be integer rounded.}
}
\description{
Imputes missing degree values
}
\details{
This function imputes degree values using the weighted mean or quantile values of the non-missing degrees.
Weights are calcualted using Gile's SS if N is not NULL, or RDS-II if it is. If a trait variable is specified,
means and quantile are calculated within the levels of the trait variable
}
\examples{
data(faux)
rds.data <- faux
rds.data$network.size[c(1,2,30,52,81,101,108,111)] <- NA
impute.degree(rds.data)
impute.degree(rds.data,trait.variable="X")
impute.degree(rds.data,trait.variable="X",method="quantile")
}
