% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiPhasesTransition}
\alias{MultiPhasesTransition}
\title{Transition range for a succession of phases (for phases in temporal order constraint)}
\usage{
MultiPhasesTransition(file, position, level = 0.95, max_decimal = 0,
dec = '.', sep=',', comment.char='#')
}
\arguments{
  \item{file}{name of the CSV file containing the output of the MCMC algorithm of all pahses of interest}
  \item{position}{numeric vector containing the position of the beginning of the phases of interest in the CSV file}
  \item{level}{probability corresponding to the level of confidence}
  \item{max_decimal}{maximum number of decimal}
  \item{dec}{the character used in the file for decimal points for the use of read.csv()}
  \item{sep}{the field separator character for the use of read.csv()}
  \item{comment.char}{a character vector of length one containing a single character or an empty string for the use of read.csv()}
}
\value{
Returns a matrix of values containing the level of confidence and the endpoints of the transition interval for each pair of successive phases
}
\description{
Finds if it exists the shortest interval [TransitionRangeInf, TransitionRangeSup] that satisfies : P(TransitionRangeInf < Phase1End < Phase2Beginning < TransitionRangeSup  | M) = level
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Phases)
  write.csv(Phases, "data.csv")
  MultiPhasesGap("data.csv", c(4,2), 0.95, 0)
}
\keyword{ transition between two phases  }
\keyword{ temporal order }
