% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{generate_grouped_factorstructure}
\alias{generate_grouped_factorstructure}
\title{Generates the true groupfactorstructure, to use in simulations.}
\usage{
generate_grouped_factorstructure(
  S,
  kg_true,
  TT,
  g_true,
  lgr_factor_mean = 0,
  lgr_factor_sd = 1,
  fgr_factor_mean = 1,
  fgr_factor_sd = 1
)
}
\arguments{
\item{S}{true number of groups}

\item{kg_true}{vector with as length the number of groups, where each element is the true number of groupfactors of that group.}

\item{TT}{length of time series}

\item{g_true}{vector of length NN with true group memberships}

\item{lgr_factor_mean}{mean of the normal distribution from which the loadings are generated}

\item{lgr_factor_sd}{sd of the normal distribution from which the loadings are generated (multiplied by a coefficient for each different group)}

\item{fgr_factor_mean}{mean of the normal distribution from which the group specific factors are generated (multiplied by a coefficient for each different group)}

\item{fgr_factor_sd}{sd of the normal distribution from which the group specific factors are generated}
}
\value{
list: first element contains the true group specific factors and the second element contains the corresponding loadings
}
\description{
Loadings and factors are generated by:
factors ~ N(j * fgr_factor_mean, fgr_factor_sd) -> default case will be N(j, 1)
loadings ~ N(lgr_factor_mean, j * lgr_factor_sd) -> default case will be N(0, j)
}
