% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{calculate_mse_beta}
\alias{calculate_mse_beta}
\title{Function to calculate the mean squared error of beta_est.}
\usage{
calculate_mse_beta(
  beta_est,
  beta_true,
  NN,
  TT,
  g_true,
  method_estimate_beta,
  without_intercept = FALSE,
  special_case_dgp1 = FALSE
)
}
\arguments{
\item{beta_est}{estimated values of beta}

\item{beta_true}{true coefficients of the observable variables}

\item{NN}{number of time series}

\item{TT}{length of time series}

\item{g_true}{vector of length NN with true group memberships}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{without_intercept}{TRUE of FALSE: to remove the intercept in the calculation of the MSE}

\item{special_case_dgp1}{special case for data generated according to dgp 1: it changes the 1st variable in X to 1 (-> intercept). Consequently the estimation of beta needs to be restructured slightly.}
}
\value{
numeric, or NA if the true number of variables is not equal to the standard of 3
}
\description{
For DGP 1 & 2: When the true number of variables in X is not equal to the standard of 3 it currently returns NA.
}
\examples{
set.seed(1)
beta_est <- matrix(rnorm(30 * 4), ncol = 30) #random values for beta
beta_true <- matrix(rnorm(4 * 3), nrow = 4)
g_true <- round(runif(30, 1,3)) #random values for true group membership
calculate_mse_beta(beta_est, beta_true, 30, 10, g_true, "individual")
}
