% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMonthlyStat.R
\name{makeMonthlyStat}
\alias{makeMonthlyStat}
\title{Compute monthly statistic of a variable}
\usage{
makeMonthlyStat(x, verbose = FALSE, sortData = FALSE, FUN = mean, ...)
}
\arguments{
\item{x}{A \code{\link{cmip5data}} object}

\item{verbose}{logical. Print info as we go?}

\item{sortData}{logical. Sort \code{x} and \code{area} before computing?}

\item{FUN}{function. Function to apply across months of year}

\item{...}{Other arguments passed on to \code{FUN}}
}
\value{
A \code{\link{cmip5data}} object, whose \code{val} field is the monthly
mean of the variable. A \code{numYears} field is also added
recording the number of years averaged for each month.
}
\description{
We frequently want to summarize CMIP5 data by month, e.g. to understand how
air temperature varies over the year for a particular data range. This function 
does that for monthly data. The default statistic is \link{mean}, but any 
summary function that returns a numeric result can be used.
}
\details{
The stat function is calculated for all combinations of lon,
lat, and Z (if present).
}
\note{
If \code{x} is not in a needed order (for example, \code{FUN} uses
weights in a different order), be sure to specify \code{sortData=TRUE}.
}
\examples{
d <- cmip5data(1970:1975)   # sample data
makeMonthlyStat(d)
summary(makeMonthlyStat(d))
summary(makeMonthlyStat(d, FUN=sd))
}
\seealso{
\code{\link{makeAnnualStat}} \code{\link{makeZStat}} \code{\link{makeGlobalStat}}
}

