% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters.R
\name{remove_label_pieces}
\alias{remove_label_pieces}
\title{Remove a prepositional phrase in a row or column label}
\usage{
remove_label_pieces(
  labels,
  pieces_to_remove,
  prepositions = RCLabels::prepositions_list,
  inf_notation = TRUE,
  notation = RCLabels::notations_list,
  choose_most_specific = FALSE
)
}
\arguments{
\item{labels}{The row and column labels from which prepositional phrases will be removed.}

\item{pieces_to_remove}{The names of pieces of the label to be removed,
typically "noun" or a preposition such as "of" or "in"
See \code{RCLabels::prepositions_list} for a list of known prepositions.}

\item{prepositions}{A list of prepositions, used to detect prepositional phrases.
Default is \code{RCLabels::prepositions_list}.}

\item{inf_notation}{A boolean that tells whether to infer notation for \code{x}.
Default is \code{TRUE}.
See \code{infer_notation()} for details.}

\item{notation}{The notation type to be used when extracting prepositions.
Default is \code{RCLabels::notations_list}, meaning that
the notation is inferred using \code{infer_notation()}.}

\item{choose_most_specific}{A boolean that tells whether the most specific
notation is selected when more than one notation match.
Default is \code{FALSE}.}
}
\value{
\code{labels} with pieces removed.
}
\description{
This function removes pieces from
row and column labels.
}
\examples{
labs <- c("a [of b in c]", "d [-> e in f]")
remove_label_pieces(labs, pieces_to_remove = "of")
remove_label_pieces(labs, pieces_to_remove = c("of", "->"))
remove_label_pieces(labs, pieces_to_remove = c("in", "into"))
remove_label_pieces(labs, pieces_to_remove = c("of", "in"))
}
