% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{paste_pieces}
\alias{paste_pieces}
\title{Recombine row and column labels}
\usage{
paste_pieces(splt_labels, notation = RCLabels::bracket_notation)
}
\arguments{
\item{splt_labels}{A vector of split row or column labels, probably created by \code{split_labels()}.}

\item{notation}{The notation object that describes the labels.
Default is \code{RCLabels::bracket_notation}.}
}
\value{
Recombined row and column labels.
}
\description{
This function recombines (unsplits) row or column labels that have
been separated by \code{split_labels()}.
}
\examples{
labs <- c("a [of b in c]", "d [from Coal mines in USA]")
labs
split <- split_labels(labs)
split
paste_pieces(split)
# Also works in a data frame
df <- tibble::tibble(labels = c("a [in b]", "c [of d into USA]",
                                "e [of f in g]", "h [-> i in j]"))
recombined <- df |>
  dplyr::mutate(
    splits = split_labels(labels),
    recombined = paste_pieces(splits)
  )
all(recombined$labels == recombined$recombined)
}
