% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delaunay.R
\name{delaunayArea}
\alias{delaunayArea}
\title{Area of Delaunay trianguation}
\usage{
delaunayArea(del)
}
\arguments{
\item{del}{an output of \code{\link{delaunay}}}
}
\value{
A number, the area of the Delaunay triangulation.
}
\description{
Computes the area of a Delaunay triangulation.
}
\examples{
library(RCDT)
set.seed(666)
library(uniformly)
square <- rbind(
  c(-1, 1), c(1, 1), c(1, -1), c(-1, -1)
)
pts <- rbind(square, runif_in_cube(8L, d = 2L))
del <- delaunay(pts)
delaunayArea(del)

# a constrained Delaunay triangulation ####
innerSquare <- rbind( # the hole
  c(-1, 1), c(1, 1), c(1, -1), c(-1, -1)
) # area: 4
outerSquare <- 2*innerSquare # area: 16
edges <- rbind(c(1, 2), c(2, 3), c(3, 4), c(4, 1))
edges <- rbind(edges, edges + 4)
del <- delaunay(points = rbind(innerSquare, outerSquare), edges = edges)
delaunayArea(del) # 16-4
}
