% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_plot.R
\name{forest_plot}
\alias{forest_plot}
\title{Forest Plot}
\usage{
forest_plot(
  x,
  prob = 0.95,
  est = c("both", "MAP", "Mean", "none"),
  model = c("stratified", "both", "meta"),
  point_est = c("median", "mean"),
  size = 1.25,
  alpha = 0.5
)
}
\arguments{
\item{x}{\code{\link{gMAP}} object.}

\item{prob}{confidence interval width and probability mass of credible intervals.}

\item{est}{can be set to one of \code{both} (default), \code{MAP}, \code{Mean} or \code{none}. Controls which model estimates are to be included.}

\item{model}{controls which estimates are displayed per study. Either \code{stratified} (default), \code{both} or \code{meta}.}

\item{point_est}{shown point estimate. Either \code{median} (default) or \code{mean}.}

\item{size}{controls point and linesize.}

\item{alpha}{transparency of reference line. Setting \code{alpha=0}
suppresses the reference line.}
}
\value{
The function returns a \pkg{ggplot2} plot object.
}
\description{
Creates a forest plot for \code{\link{gMAP}} analysis objects.
}
\details{
The function creates a forest plot suitable for
\code{\link{gMAP}} analyses. Note that the Meta-Analytic-Predictive
prior is included by default in the plot as opposed to only showing
the estimated model mean. See the examples below to obtain standard
forest plots.

Also note that the plot internally flips the x and
y-axis. Therefore, if you want to manipulate the x-axis, you have
to give commands affecting the y-axis (see examples).
}
\section{Customizing \pkg{ggplot2} plots}{


The returned plot is a \pkg{ggplot2} object. Please refer to the
"Customizing Plots" vignette which is part of \pkg{RBesT}
documentation for an introduction. For simple modifications (change
labels, add reference lines, ...) consider the commands found in
\code{\link[bayesplot]{bayesplot-helpers}}. For more advanced
customizations please use the \pkg{ggplot2} package directly. A
description of the most common tasks can be found in the
\href{http://www.cookbook-r.com/Graphs/}{R Cookbook} and a full
reference of available commands can be found at the
\href{https://ggplot2.tidyverse.org/reference/}{ggplot2 documentation
site}.
}

\examples{
# we consider the example AS MAP analysis
example(AS)

# default forest plot for a gMAP analysis
forest_plot(map_AS)

# standard forest plot (only stratified estimate and Mean)
forest_plot(map_AS, est=c("Mean"), model="stratified")

# to further customize these plots, first load bayesplot and ggplot2
library(bayesplot)
library(ggplot2)

# to make plots with red colors, big fonts for presentations, suppress
# the x axis label and add another title (with a subtitle)
color_scheme_set("red")
theme_set(theme_default(base_size=16))
forest_plot(map_AS, size=2) +
   yaxis_title(FALSE) +
     ggtitle("Ankylosing Spondylitis Forest Plot",
             subtitle="Control Group Response Rate")

# the defaults are set with
color_scheme_set("blue")
theme_set(theme_default(base_size=12))

}
\seealso{
\code{\link{gMAP}}
}
