% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apparmor.R
\name{apparmor}
\alias{apparmor}
\alias{aa_change_hat}
\alias{aa_revert_hat}
\alias{aa_change_profile}
\alias{aa_find_mountpoint}
\alias{aa_getcon}
\alias{aa_is_enabled}
\alias{aa_is_compiled}
\title{Change hats}
\usage{
aa_change_hat(subprofile, magic_token)

aa_revert_hat(magic_token)

aa_change_profile(profile)

aa_find_mountpoint()

aa_getcon()

aa_is_enabled()

aa_is_compiled()
}
\arguments{
\item{subprofile}{character string identifying the subprofile (hat) name (without the "^")}

\item{magic_token}{a number that will be the key to revert out of the hat.}

\item{profile}{character string with the name of the profile.}
}
\description{
A hat is a subprofile which name starts with a '^'.
The difference between hats and profiles is that one can escape (revert) from the hat using the token.
Hence this provides more limited security than a profile.

Note that in order for this function to do its work, it needs
read access to the attributes of the current process. If aa_getcon
fails with a permission denied error, it might actually mean
that the current process is being confined with a very restrictive
profile.
}
\examples{
\dontrun{
aa_change_profile("testprofile");
aa_getcon();
test <- read.table("/etc/group");
aa_change_hat("testhat", 13337);
aa_getcon();
test <- read.table("/etc/group");
aa_revert_hat(13337);
test <- read.table("/etc/group");
}
 \dontrun{
test <- read.table("/etc/passwd");
aa_change_profile("testprofile");
aa_getcon();
test <- read.table("/etc/passwd");
}
}
