% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDperm.R
\name{RDperm}
\alias{RDperm}
\title{Regression Discontinuity Design Permutation Test}
\usage{
RDperm(W, z, data, n.perm = 499, q_type = 10, cutoff = 0,
  test.statistic = "CvM")
}
\arguments{
\item{W}{Character. Vector of covariates names. The procedure will test the null hypothesis of continuity of the distribution of each element in W at the cutoff.}

\item{z}{Character. Running variable name. This is the scalar random variable that defines, along with the cutoff, the treatment assignment rule in the sharp regression discontinuity design.}

\item{data}{Data.frame.}

\item{n.perm}{Numeric. Number of permutations needed for the stochastic approximation of the p-values. See remark 3.2 in Canay and Kamat (2017). The default is B=499.}

\item{q_type}{A fixed and small (relative to the sample size) natural number that will define the \eqn{q}{q} closest values of the order statistic of \eqn{Z}{Z} to the right and to the left of the cutoff. The default, 'rot', value is given by the feasible rule of thumb in footnote 4 of Canay and Kamat (2017), section 3.1. If 'arot', it calls for the Rule of Thumb described in equation (15) of Canay and Kamat (2017), section 3.1. The default option grows at a slower rate than the optional rule of thumb, but adds a larger constant.}

\item{cutoff}{Numeric. The scalar defining the threshold of the running variable.}

\item{test.statistic}{Character. A rank test statistic satisfying rank invariance. The default is a Cramer-von Mises test statistic.}
}
\value{
The functions \code{summary} and \code{plot} are used to obtain and print a summary and plot of
the estimated regression discontinuity. The object of class \code{RDperm} is a list
containing the following components:
 \item{results}{Matrix. Test Statistic, P-values and Q}
 \item{test.statistic}{Test Statistic}
 \item{q_type}{Type of Q used in the calculations, can be either,  "Defined by User", the "Rule of Thumb"  or the "Alternative Rule of Thumb".}
 \item{n_perm}{number of permutations}
 \item{rv}{Character. Running variable name}
 \item{Z}{Vector. Running Variable}
 \item{cutoff}{cutoff}
 \item{data}{data set}
 \item{S}{Matrix. Pooled sample of induced order statistics}
 \item{S_perm}{List. Permutations of the induced order statistic.}
}
\description{
A permutation test for continuity of covariates in Sharp Regression Discontinuity Design as described in Canay and Kamat (2017).
}
\examples{
permtest<-RDperm(W=c("demshareprev"),z="difdemshare",data=lee2008)
summary(permtest)
\dontrun{
permtest<-RDperm(W=c("demshareprev","demwinprev"),z="difdemshare",data=lee2008)
summary(permtest)
}
}
\references{
Canay, I and Kamat V, (2017) Approximate Permutation Tests and Induced Order Statistics in the Regression Discontinuity Design. \url{http://faculty.wcas.northwestern.edu/~iac879/wp/RDDPermutations.pdf}
}
\author{
Maurcio Olivares Gonzalez

Ignacio Sarmiento Barbieri
}
\keyword{permutation}
\keyword{rdperm}
\keyword{test}
