% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.convert.data.r
\name{lsa.convert.data}
\alias{lsa.convert.data}
\title{Convert Large-Scale Assessments' Datasets to .RData Format}
\usage{
lsa.convert.data(
  inp.folder,
  PISApre15 = FALSE,
  ISO,
  missing.to.NA = FALSE,
  out.folder
)
}
\arguments{
\item{inp.folder}{The folder containing the IEA-like SPSS data files or text ASCII files and
\code{.sps} import files for OECD PISA data from cycles prior to 2015 (see the details).
If blank, the working directory (\code{getwd()}) is used.}

\item{PISApre15}{When converting PISA files, set to \code{TRUE} if the input files are from
PISA cycles prior 2015 (ASCII text format with \code{.sps} control files)
or to \code{FALSE} (default) if they are in SPSS \code{.sav} format, as in
the case of IEA studies and the like and OECD PISA 2015 or later. Ignored if
the input folder contains IEA-like studies.}

\item{ISO}{Vector containing character ISO codes of the countries' data files to convert
(e.g. \code{ISO = c("aus", "svn")}). If none of the files contain the
specified ISO codes in their names, the codes are ignored and a warning is
shown. Ignored when converting PISA files (both for cycles prior 2015 and
2015 and later). This argument is case-insensitive, i.e. the ISO codes can be
passed as lower- or upper-case.
(lower or upper) as the original SPSS \code{.sav} files.}

\item{missing.to.NA}{Should the user-defined missing values be recoded to \code{NA}? If \code{TRUE},
all user-defined missing values from the SPSS files (or specified in the OECD PISA
import syntax files) are all imported as \code{NA}. If \code{FALSE} (default),
they are converted to valid values and the missing codes are assigned to
an attribute \code{missings} for each variable.}

\item{out.folder}{Path to the folder where the converted files will be stored. If blank, same
as the \code{inp.folder}, and if the \code{inp.folder} is missing as well,
this will be \code{getwd()}.}
}
\value{
\code{.RData} data files, containing an object with class \code{lsa.data}, an extension of the \code{data.table} class. The \code{data.table} object has the same name as the \code{.RData} file it is saved in. The object has additional attributes: study name (\code{study}), study cycle (\code{cycle}), and respondent file type (\code{file.type}). Each variable has its own additional attributes: its own label attached to it, if it existed in the source SPSS file. If the \code{missing.to.NA} was set to \code{TRUE}, each variable has an attribute \code{missings}, containing the user-defined missing values from the SPSS files.

The object in the \code{.RData} file is keyed on the country ID variable.
}
\description{
\code{lsa.convert.data} converts datasets from large-scale assessments from their original (SPSS) format into \code{.RData} files.
}
\details{
IEA studies, as well as some OECD ones and those conducted by multiple organizations, provide their data in SPSS \code{.sav} format with same or very similar structure: one file per country and type of respondent (e.g. school principal, student, teacher, etc.) per population. Cycles of OECD PISA prior to 2015, on the other hand, do not provide SPSS \code{.sav} or other binary files, but ASCII text files, accompanied with SPSS syntax (\code{.sps}) files that are used to import the text files into SPSS. These files are per each type of respondent containing all countries' data. The \code{lsa.convert.data} function converts the data from either source assuring that the structure of the output \code{.RData} files is the same, although the structure of the input files is the different (SPSS binary files vs. ASCII text files plus import \code{.sps} files). The data from PISA 2015 and later, on the other hand, is provided in SPSS format (all countries in one file per type of respondent). Thus, the \code{PISApre15} argument needs to be specified as \code{TRUE} when converting data sets from PISA prior to its 2015 cycle. The default for the \code{PISApre15} argument is \code{FALSE} which means that the function expects to find IEA-like SPSS binary files per country and type of respondent in the directory in \code{inp.folder} or OECD PISA 2015 (or later) SPSS \code{.sav} files. If \code{PISApre15 = TRUE} and country codes are provided to \code{ISO}, they will be ignored because PISA files contain data from all countries together.

The files to be converted must be in a folder on their own, from a single study, single cycle and single population. In case of OECD PISA prior 2015, the folder must contain both the ASCII text files and the SPSS \code{.sps} import syntax files. If the folder contains data sets from more than one study or cycle, the operation will break with error messages.

If the path for the \code{inp.folder} argument is not specified, the function will search for files in the working directory (i.e. as returned by \code{getwd()}). If folder path for the the \code{out.folder} is not specified, it will take the one from the \code{inp.folder} and the files will be stored there. If both the \code{inp.folder} and \code{out.folder} arguments are missing, the directory from \code{getwd()} will be used to search, convert and store files.

If \code{missing.to.NA} is set to \code{TRUE}, all user-defined missing values from the SPSS will be imported as \code{NA} which is \code{R}'s only kind of missing value. This will be the most often case when analyzing these data since the reason why the response is missing will be irrelevant most of the times. However, if it is needed to know why the reasons for missing responses, as when analyzing achievement items (i.e. not administered vs. omitted or not reached), the argument shall be set to \code{FALSE} (default for this argument) which will convert all user-defined missing values as valid ones.
}
\note{
When downloading the \code{.sps} files (ASCII text and control \code{.sps}) for OECD PISA files prior to the 2015 cycle (say http://www.oecd.org/pisa/pisaproducts/pisa2009database-downloadabledata.htm), save them \strong{without changing their names and without modifying the file contents}. The function will look for the files as they were named originally.

Different studies and cycles define the "I don't know" (or similar) category of discrete variables in different ways - either as a valid or missing value. The \code{lsa.convert.data} function sets all such or similar codes to missing value. If this has to be changed, the \code{lsa.recode.vars} can be used as well (also see \code{lsa.vars.dict}).
}
\examples{
# Convert all IEA-like SPSS files in the working directory, setting all user-defined missing
# values to \code{NA}
\dontrun{
lsa.convert.data(missing.to.NA = TRUE)
}


# Convert IEA TIMSS 2011 grade 8 data from Australia and Slovenia, keeping all user-defined
# missing values as valid ones specifying custom input and output directories
\dontrun{
lsa.convert.data(inp.folder = "C:/TIMSS_2011_G8", ISO = c("aus", "svn"), missing.to.NA = FALSE,
out.folder = "C:/Data")
}

# Convert OECD PISA 2009 files converting all user-defined missing values to \code{NA}
# using custom input and output directories
\dontrun{
lsa.convert.data(inp.folder = "/media/PISA_2009", PISApre15 = TRUE, missing.to.NA = TRUE,
out.folder = "/tmp")
}

}
\seealso{
\code{\link{lsa.vars.dict}}, \code{\link{lsa.recode.vars}}
}
