% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.vars.dict.r
\name{lsa.vars.dict}
\alias{lsa.vars.dict}
\title{Produce dictionary for large-scale assessments data variables}
\usage{
lsa.vars.dict(
  data.file,
  data.object,
  var.names,
  out.file,
  open.out.file = FALSE
)
}
\arguments{
\item{data.file}{Full path to the \code{.RData} file containing \code{lsa.data} object.
Either this or \code{data.object} shall be specified, but not both.
See details.}

\item{data.object}{The object in the memory containing \code{lsa.data} object. Either this
or \code{data.file} shall be specified, but not both. See details.}

\item{var.names}{Vector of variable names whose dictionaries shall be produced.
See details.}

\item{out.file}{Optional, full path to a \code{.txt} file where the dictionaries shall be
saved, if needed. See details.}

\item{open.out.file}{Optional, if file path is provided to \code{out.file} shall the produced
file be open after the file is written?}
}
\value{
The dictionaries for the variables in \code{var.names} will be printed as tables on the screen. For each variable the dictionaries contain the variable name, the variable class, the variable label, unique variable values (see below) and the user-defined missing values (if any).

The unique values' representation will depend on the variable class. If the variable is a factor, the factor levels will be displayed. If the variable is numeric or character, the unique values will be printed up to the sixth one.

The user-defined missing values for factor variables will be as text strings. For the numeric variables these will be integers, followed by their labels in brackets.

If a full file path is provided to the \code{out.file}, the same output will be written to a \code{.txt} file with a text on top which data file/object was used.
}
\description{
Utility function to display dictionaries of variables from data sets containing objects of class \code{lsa.data}.
}
\details{
Either \code{data.file} or \code{data.object} shall be provided as source of data. If both of them are provided, the function will stop with an error message.

If \code{var.names} are not provided, then the function will produce dictionaries for all variables in the file/object.

The function will print the dictionaries on the screen. If these need to be saved to a file for further reference as well, a full path to the \code{.txt} file shall be provided. If the file exists, it will be overwritten. If the file name is provided to \code{out.file} and \code{open.out.file = TRUE}, it will be automatically open in the default text editor after being written.
}
\examples{
# Display and write to file the dictionaries for multiple factor and numeric variables using
# PIRLS 2016 file with teacher and student data from several countries and open the file after
# it has been written to the disk.
\dontrun{
lsa.vars.dict(data.file = "C:/temp/test.RData", var.names = c("ASBG10A", "ASBG10B", "ASBG05A",
"ASBG05B", "ASBG05C", "ASBG05D", "ASBG05E", "ASBG05F", "ASBG05G", "ASBG05H", "ASBG06",
"ASBG07A", "ASBG07B", "ASBG08", "ATBG05BA", "ATBG05BB", "ATBG05BC", "ATBG05BD"),
out.file = "C:/temp/dict.txt", open.out.file = TRUE)
}

\dontrun{
lsa.vars.dict(data.object = test, var.names = c("ASBG10A", "ASBG10B", "ASBG05A", "ASBG05B",
"ASBG05C", "ASBG05D", "ASBG05E", "ASBG05F", "ASBG05G", "ASBG05H","ASBG06", "ASBG07A",
"ASBG07B", "ASBG08", "ATBG05BA", "ATBG05BB", "ATBG05BC", "ATBG05BD"),
out.file = "C:/temp/dict.txt", open.out.file = TRUE)
}

}
\seealso{
\code{\link{lsa.convert.data}}, \code{\link{lsa.recode.vars}}
}
