% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mussel_pop_RKsolver.R
\name{Mussel_pop_RKsolver}
\alias{Mussel_pop_RKsolver}
\title{Solves the Mussel population bioenergetic balance with a 4th order Runge Kutta method}
\usage{
Mussel_pop_RKsolver(Param, times, IC, Tint, Phyint, DTint, POCint, Ccont, Ncont,
  Pcont, POMint, TSSint, N)
}
\arguments{
\item{Param}{a vector containing model parameters}

\item{times}{integration extremes and integration timestep}

\item{IC}{initial condition}

\item{Tint}{the interpolated water temperature time series}

\item{Phyint}{the interpolated phytoplankton time series}

\item{DTint}{the interpolated detritus time series}

\item{POCint}{the interpolated POC time series}

\item{Ccont}{the C/C content of the POC}

\item{Ncont}{the N/C content of POC}

\item{Pcont}{the P/C content of POC}

\item{POMint}{the interpolated POM time series}

\item{TSSint}{the interpolated TSS time series}

\item{N}{the number of indivduals time series}
}
\value{
a list containing the weights of the mussel, the excreted CNP, the mussel CNP, temperature limitation functions, metabolic rates, oxygen consumption
}
\description{
Solves the Mussel population bioenergetic balance with a 4th order Runge Kutta method
}

