% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6causal_linear.R
\name{LinearGaussianSCM}
\alias{LinearGaussianSCM}
\title{R6 Class for linear structural causal models where background variables have Gaussian distribution}
\description{
R6 Class for linear structural causal models where background variables have Gaussian distribution

R6 Class for linear structural causal models where background variables have Gaussian distribution
}
\details{
Inherits R6 class SCM.
}
\examples{

## ------------------------------------------------
## Method `LinearGaussianSCM$new`
## ------------------------------------------------

lgbackdoor <- LinearGaussianSCM$new("Linear Gaussian Backdoor",
                linear_gaussian = list(
                  uflist = list(ux = function(n) {rnorm(n)},
                                uy = function(n) {rnorm(n)},
                                uz = function(n) {rnorm(n)}),
                  vnames = c("x","y","z"),
                  vcoefmatrix = matrix(c(0,0.4,0,0,0,0,0.6,0.8,0),3,3),
                  ucoefvector = c(1,1,1),
                  ccoefvector = c(0,0,0)))
randomlg <- LinearGaussianSCM$new("Random Linear Gaussian",
                random_linear_gaussian = list(
                  nv = 10, 
                  edgeprob=0.5, 
                  vcoefdistr = function(n) {rnorm(n)}, 
                  ccoefdistr = function(n) {rnorm(n)}, 
                  ucoefdistr = function(n) {rnorm(n)}))
}
\section{Super class}{
\code{\link[R6causal:SCM]{R6causal::SCM}} -> \code{LinearGausianSCM}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{linear_gaussian_B}}{Matrix of structural coefficients of the observed variables}

\item{\code{linear_gaussian_A}}{Matrix of structural coefficients of the background variables}

\item{\code{linear_gaussian_c}}{Vector of constants in structural coefficients}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LinearGausianSCM-new}{\code{LinearGaussianSCM$new()}}
\item \href{#method-LinearGausianSCM-clone}{\code{LinearGaussianSCM$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="add_variable"><a href='../../R6causal/html/SCM.html#method-SCM-add_variable'><code>R6causal::SCM$add_variable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="an"><a href='../../R6causal/html/SCM.html#method-SCM-an'><code>R6causal::SCM$an()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="causal.effect"><a href='../../R6causal/html/SCM.html#method-SCM-causal.effect'><code>R6causal::SCM$causal.effect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="ch"><a href='../../R6causal/html/SCM.html#method-SCM-ch'><code>R6causal::SCM$ch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="de"><a href='../../R6causal/html/SCM.html#method-SCM-de'><code>R6causal::SCM$de()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="dosearch"><a href='../../R6causal/html/SCM.html#method-SCM-dosearch'><code>R6causal::SCM$dosearch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="intervene"><a href='../../R6causal/html/SCM.html#method-SCM-intervene'><code>R6causal::SCM$intervene()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="pa"><a href='../../R6causal/html/SCM.html#method-SCM-pa'><code>R6causal::SCM$pa()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="plot"><a href='../../R6causal/html/SCM.html#method-SCM-plot'><code>R6causal::SCM$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="print"><a href='../../R6causal/html/SCM.html#method-SCM-print'><code>R6causal::SCM$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="remove_variable"><a href='../../R6causal/html/SCM.html#method-SCM-remove_variable'><code>R6causal::SCM$remove_variable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="simulate"><a href='../../R6causal/html/SCM.html#method-SCM-simulate'><code>R6causal::SCM$simulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="R6causal" data-topic="SCM" data-id="tikz"><a href='../../R6causal/html/SCM.html#method-SCM-tikz'><code>R6causal::SCM$tikz()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LinearGausianSCM-new"></a>}}
\if{latex}{\out{\hypertarget{method-LinearGausianSCM-new}{}}}
\subsection{Method \code{new()}}{
Create a new linear Gaussian SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LinearGaussianSCM$new(
  name = "A linear Gaussian SCM",
  linear_gaussian = NULL,
  random_linear_gaussian = NULL,
  rflist = NULL,
  rprefix = "R_",
  starsuffix = "_md"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name.}

\item{\code{linear_gaussian}}{A list with the following elements:
\itemize{
\item uflist: A named list containing the functions for the background variables.
\item vnames: A vector of names of the observed variables.
\item vcoefmatrix: A matrix of coefficients for observed variables in the structural equations.
\item ucoefvector: A vector of the coefficients of dedicated error terms in the structural equations.
\item ccoefvector: A vector of constant terms in the structural equations.
\item u2coefmatrix: A matrix of the coefficients of confounding background variables in the structural equations. The number of rows equals the number of the observed variables and the number of columns equals the number of confounding background variables.
}}

\item{\code{random_linear_gaussian}}{A list with the following elements:
\itemize{
\item nv: The number of observed variables
\item edgeprob: The probability of an edge between a pair of observed variables (provide either edgeprob or avgneighbors)
\item avgneighbors: The average number of edges per a vertex (provide either edgeprob or avgneighbors)
\item u2prob: The probability of unobserved confounder between a pair of observed variables (provide either u2prob or avgu2)
\item avgu2: The average number of unobserved confounders per a vertex (provide either u2prob or avgu2)
\item vcoefdistr: A function that generates the coefficients of observed variables in the structural equations. The function must have argument 'n'.
\item ucoefdistr: A function that generates the coefficients of dedicated error terms in the structural equations. The function must have argument 'n'.
\item ccoefdistr: A function that generates the constants in the structural equations. The function must have argument 'n'.
\item u2coefdistr: A function that generates the coefficients of confounding background variables in the structural equations. The function must have argument 'n'.
}}

\item{\code{rflist}}{A named list containing the functions for missingness indicators.}

\item{\code{rprefix}}{The prefix of the missingness indicators.}

\item{\code{starsuffix}}{The suffix for variables with missing data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `LinearGaussianSCM` object that also belongs to class `SCM`.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{lgbackdoor <- LinearGaussianSCM$new("Linear Gaussian Backdoor",
                linear_gaussian = list(
                  uflist = list(ux = function(n) {rnorm(n)},
                                uy = function(n) {rnorm(n)},
                                uz = function(n) {rnorm(n)}),
                  vnames = c("x","y","z"),
                  vcoefmatrix = matrix(c(0,0.4,0,0,0,0,0.6,0.8,0),3,3),
                  ucoefvector = c(1,1,1),
                  ccoefvector = c(0,0,0)))
randomlg <- LinearGaussianSCM$new("Random Linear Gaussian",
                random_linear_gaussian = list(
                  nv = 10, 
                  edgeprob=0.5, 
                  vcoefdistr = function(n) {rnorm(n)}, 
                  ccoefdistr = function(n) {rnorm(n)}, 
                  ucoefdistr = function(n) {rnorm(n)}))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LinearGausianSCM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LinearGausianSCM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LinearGaussianSCM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
