% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/means.r
\name{means}
\alias{means}
\title{Calculate summary statistics on a data frame}
\usage{
means(dfrm, variable, by, total = NULL, pack = 1, dig = 2, alpha = 0.1)
}
\arguments{
\item{dfrm}{the data frame to calculate the statistics on}

\item{variable}{character with the variable within the data frame for which the statistics should be calculated}

\item{by}{character vector of variable(s) within the data frame to stratify the statistics on}

\item{total}{character vector of variable(s) within the data frame to calculate totals on}

\item{pack}{numeric indicating number of the pack or name of the function with different descriptive statistics (see details)}

\item{dig}{the number of digits to use for output statistics (except for N which is always displayed as integer)}

\item{alpha}{the alpha in case the statistics pack calculates confidence limits}
}
\value{
The function returns a dataframe with calculated descriptive statistics
}
\description{
This function calculates summary statistics on a data frame. It is intended to use to
calculate a standard number of descriptive statistics which are defined in the packs argument
}
\details{
The function calculates multiple statistics of a data frame that can be stratified. Furthermore, the statistics for a total
  can also be generated. Currently the function has the possibility to calculate 3 different sets of statistics which are commonly
  used within the field of clinical data analysis:
  \enumerate{
    \item N, Mean, Median, SD, Min, Max
    \item Ntot, N, Nmiss, Mean, Median, SD, Min, Max, CLM (different N values are given to identify the number of missing values)
    \item N, Mean (SD), Median, Range (Both Mean (SD) and Range are concatenated to generate a dense overview of statistics)
  }
All statistics are calculated on using na.rm set to TRUE, meaning that NA values are removed before calculating the statistics.
A predefined set of statistics is chosen and not the possibility to implement user defined descriptive statistics.
The reason for this is that there are many other (more simple) options to do this within R.
}
\examples{

data(Indometh)
means(Indometh,"conc","time",total="time",pack=3)
}
