% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multimarray.R
\name{multimarray}
\alias{multimarray}
\title{Multistate m-array}
\usage{
multimarray(X, freq)
}
\arguments{
\item{X}{a matrix of encounter histories over K occasions}

\item{freq}{is a vector with the number of individuals having the corresponding encounter history}
}
\value{
This function returns a matrix in which R the number of released individuals is in the first column, the number of individuals never recaptured (K-1) is in the last column and m the m-array (K-1 x K-1) with upper triangle filled only is in sandwich between these two vectors.
}
\description{
This function calculates the m-array for multistate capture-recapture data, the number of released and never seen again individuals.
}
\examples{
# Read in Geese dataset:
geese = system.file("extdata", "geese.inp", package = "R2ucare")
geese = read_inp(geese)

# Get encounter histories and number of individuals with corresponding histories
geese.hist = geese$encounter_histories
geese.freq = geese$sample_size

# build m-array
multimarray(geese.hist, geese.freq)
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>,Jean-Dominique Lebreton, Rémi Choquet, Roger Pradel
}
\keyword{package}

