% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twosample_power.R
\name{twosample_power}
\alias{twosample_power}
\title{twosample_power}
\usage{
twosample_power(
  rxy,
  alpha = 0.05,
  B = 1000,
  avals = 0,
  bvals = 0,
  nbins = c(100, 10),
  maxProcessor = 10,
  doMethod = "all"
)
}
\arguments{
\item{rxy}{function to generate a list with data sets x, y and (optional) vals}

\item{alpha}{=0.05, level of hypothesis test}

\item{B}{=1000, number of simulation runs for permutation test and power.}

\item{avals}{parameter for function that generates x and y.}

\item{bvals}{parameter for function that generates x and y.}

\item{nbins}{=c(100,10), number of bins for chi large and chi small.}

\item{maxProcessor}{=10, maximum number of cores to use. If maxProcessor=1 no parallel computing is used.}

\item{doMethod}{="all", which methods should be included?}
}
\value{
A numeric vector of power values.
}
\description{
Find the power of various two sample tests using Rcpp and parallel computing.
}
\examples{
 rxy=function(a,b) list(x=rnorm(50), y=rnorm(50,0.5))
 twosample_power(rxy, B=100, maxProcessor = 1)
 rxy=function(a,b) list(x=table(sample(1:10, size=1000, replace=TRUE)), 
       y=table(sample(1:10, size=1200, replace=TRUE)), vals=1:10)
 twosample_power(rxy, B=100, maxProcessor = 1)
}
