% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\name{cooc_terms}
\alias{cooc_terms}
\title{cooc_terms}
\usage{
cooc_terms(dtm, term, variable = NULL, p = 0.1, n = 25,
  sparsity = 1, min_occ = 2)
}
\arguments{
\item{dtm}{A \code{DocumentTermMatrix}.}

\item{term}{A reference term appearing in \code{dtm}.}

\item{variable}{An optional vector of values giving the groups for which most frequent
terms should be reported.}

\item{p}{The maximum p-value up to which terms should be reported.}

\item{n}{The maximal number of terms to report (for each group, if applicable).}

\item{sparsity}{Value between 0 and 1 indicating the proportion of documents
with no occurrences of a term above which that term should be dropped. By default
all terms are kept (\code{sparsity=1}).}

\item{min_occ}{The minimum number of occurrences in the whole \code{dtm} below which
terms should be skipped.}
}
\value{
A list of matrices, one for each level of the variable, with columns:
\itemize{
\item "\% Term/Level": the percent of the term's occurrences in all terms occurrences
in documents where the chosen term is also present.
\item "\% Level/Term": the percent of the term's occurrences that appear in documents
where the chosen term is also present (rather than in documents where it does not appear),
i.e. the percent of cooccurrences for the term..
\item "Global \%": the percent of the term's occurrences in all terms occurrences
in the corpus (or in the subset of the corpus corresponding to the variable level).
\item "Level": the number of cooccurrences of the term.
\item "Global": the number of occurrences of the term in the corpus
(or in the subset of the corpus corresponding to the variable level).
\item "t value": the quantile of a normal distribution corresponding the probability "Prob.".
\item "Prob.": the probability of observing such an extreme (high or low) number of occurrences of
the term in documents where the chosen term is also present, under an hypergeometric distribution.
}
}
\description{
Show terms that are the most associated (positively or negatively)
with a reference term.
}
\details{
Co-occurrent terms are those which are specific to documents which contain
the given term. The output is the same as that returned by \code{\link{specific_terms}}.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
cooc_terms(dtm, "barrel")
cooc_terms(dtm, "barrel", meta(corpus)$Date)

}
