% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ret_lum.R
\name{ret_lum}
\alias{ret_lum}
\title{Adjust the Brightness of a Hex Color}
\usage{
ret_lum(hexCol, rgbFact)
}
\arguments{
\item{hexCol}{Character. The color to adjust, specified in
hexadecimal format (e.g., "#FF5733").}

\item{rgbFact}{Numeric. The luminosity factor :
- use a factor between 0 and 1 to decrease luminosity
- use a factor >1 to increase it
The final Brightness value will be maintained between 0 and 1.}
}
\value{
A modified hex color in hexadecimal format.
}
\description{
Modifies the brightness of a color by multiplying its RGB
components by a specified factor.

Mostly for internal usage inside lum_0_100 function.
}
\examples{
# Example 1: Lightening a color
ret_lum("#FF5733", 1.5)  # Returns a lighter version of the input color

# Example 2: Darkening a color
ret_lum("#FF5733", 0.7)  # Returns a darker version of the input color

}
