% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rtimer.R
\name{Rtimer}
\alias{Rtimer}
\title{Timer Class for Performance Measurement}
\description{
Timer Class for Performance Measurement

Timer Class for Performance Measurement
}
\details{
An R6 class for measuring and tracking execution time of code segments.
Provides functionality to add timing checkpoints, calculate time differences,
and generate summary reports of performance metrics.
}
\section{Public Methods}{

\describe{
  \item{\code{new()}}{Initialize a new Timer instance.}
  \item{\code{add(...)}}{Add a timing checkpoint with optional labels.}
  \item{\code{get(fill = TRUE)}}{Generate timing results as data.table.}
}
}

\examples{
\dontrun{
tmr <- Rtimer$new()
tmr$add("start")
# some code
tmr$add("end")
result <- tmr$get()
print(result)
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Timer-new}{\code{Rtimer$new()}}
\item \href{#method-Timer-add}{\code{Rtimer$add()}}
\item \href{#method-Timer-get}{\code{Rtimer$get()}}
\item \href{#method-Timer-clone}{\code{Rtimer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Timer-new"></a>}}
\if{latex}{\out{\hypertarget{method-Timer-new}{}}}
\subsection{Method \code{new()}}{
Create a new Timer instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rtimer$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A Rtimer object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Timer-add"></a>}}
\if{latex}{\out{\hypertarget{method-Timer-add}{}}}
\subsection{Method \code{add()}}{
Add a timestamp
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rtimer$add(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional named labels attached to the timestamp.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object itself (invisible) for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Timer-get"></a>}}
\if{latex}{\out{\hypertarget{method-Timer-get}{}}}
\subsection{Method \code{get()}}{
Return the collected timings as a \code{data.table}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rtimer$get(fill = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fill}}{Logical; if \code{TRUE}, fill missing columns when combining entries}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.table} containing timestamps and time differences
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Timer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Timer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rtimer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
