% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tqDist.r
\name{Distances}
\alias{Distances}
\alias{QuartetDistance}
\alias{QuartetAgreement}
\alias{PairsQuartetDistance}
\alias{OneToManyQuartetAgreement}
\alias{AllPairsQuartetDistance}
\alias{AllPairsQuartetAgreement}
\alias{TripletDistance}
\alias{PairsTripletDistance}
\alias{AllPairsTripletDistance}
\title{Triplet and quartet distances with tqDist}
\usage{
QuartetDistance(file1, file2)

QuartetAgreement(file1, file2)

PairsQuartetDistance(file1, file2)

OneToManyQuartetAgreement(file1, file2)

AllPairsQuartetDistance(file)

AllPairsQuartetAgreement(file)

TripletDistance(file1, file2)

PairsTripletDistance(file1, file2)

AllPairsTripletDistance(file)
}
\arguments{
\item{file, file1, file2}{Paths to files containing a tree or trees in Newick format.}
}
\value{
\code{Distance} functions return the distance between the requested trees.

\code{Agreement} functions return the number of triplets or quartets that are:
\itemize{
\item \code{A}, resolved in the same fashion in both trees;
\item \code{E}, unresolved in both trees.
}

Comparing a tree against itself yields the totals (\code{A+B+C}) and (\code{D+E})
referred to by Brodal \emph{et al}. (2013) and Holt \emph{et al}. (2014).
}
\description{
Functions to calculate triplet and quartet distances between pairs of trees.
}
\section{Functions}{
\itemize{
\item \code{QuartetDistance}: Returns the quartet distance between the tree.
in \code{file1} and the tree in \code{file2}.

\item \code{QuartetAgreement}: Returns a vector of length two, listing [1]
the number of resolved quartets that agree (\code{A});
[2] the number of quartets that are unresolved in both trees (\code{E}).
See Brodal et al. (2013).

\item \code{PairsQuartetDistance}: Quartet distance between the tree on each line of \code{file1}
and the tree on the corresponding line of \code{file2}.

\item \code{OneToManyQuartetAgreement}: Quartet distance between the tree in
\code{file1} and the tree on each line of \code{file2}.

\item \code{AllPairsQuartetDistance}: Quartet distance between each tree listed in \code{file} and
each other tree therein.

\item \code{AllPairsQuartetAgreement}: Quartet status for each pair of trees in \code{file}.

\item \code{TripletDistance}: Triplet distance between the single tree given
in each file.

\item \code{PairsTripletDistance}: Triplet distance between the tree on each line of \code{file1}
and the tree on the corresponding line of \code{file2}.

\item \code{AllPairsTripletDistance}: Triplet distance between each tree listed in \code{file} and
each other tree therein.
}}

\references{
{
\insertRef{Brodal2013}{Quartet}

\insertRef{Holt2014}{Quartet}

\insertRef{Sand2014}{Quartet}
}
}
\author{
\itemize{
\item Algorithms: Brodal \emph{et al.} (2013); Holt \emph{et al.} (2014).
\item C implementation: Sand \emph{et al.} (2014);
modified for portability by Martin R. Smith.
\item R interface: Martin R. Smith.
}
}
\concept{Tree distances}
