% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QuantumClone.R
\name{Cluster_plot_from_cell}
\alias{Cluster_plot_from_cell}
\title{Cellularity clustering}
\usage{
Cluster_plot_from_cell(Cell, Sample_names, simulated, save_plot = T,
  contamination, clone_priors, prior_weight, nclone_range, maxit,
  preclustering = T, epsilon = 5 * (10^(-3)), ncores = 2,
  plot_3D_before_clustering = F, output_directory = NULL)
}
\arguments{
\item{Cell}{Output from Return_one_cell_by_mut, list of cellularities (one list-element per sample)}

\item{Sample_names}{Name of the sample}

\item{simulated}{Was the data generated by QuantumCat?}

\item{save_plot}{Should the clustering plots be saved? Default is True}

\item{contamination}{The fraction of normal cells in the samples}

\item{clone_priors}{If known a list of priors (cell prevalence) to be used in the clustering}

\item{prior_weight}{If known a list of priors (fraction of mutations in a clone) to be used in the clustering}

\item{nclone_range}{Number of clusters to look for}

\item{maxit}{Maximal number of independant initial condition tests to be tried}

\item{preclustering}{Boolean: should a kmeans be performed on A and AB sites to determine priors}

\item{epsilon}{Stop value: maximal admitted value of the difference in cluster position and weights between two optimization steps.}

\item{ncores}{Number of CPUs to be used}

\item{plot_3D_before_clustering}{Should a 3D plot be realized before clustering, can be useful to guess priors.}

\item{output_directory}{Directory in which to save results}
}
\description{
Clustering cellularities based on  the most likely presence of a clone, using the pamk algorithm (fpc package). Clustering can be guided by toggling manual_clustering on and/or giving a range of number of clusters.
}
\keyword{Clonal}
\keyword{inference}

