% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_RollLinReg.R
\name{RollLinReg}
\alias{RollLinReg}
\title{c++ Rolling Linear Regression class}
\arguments{
\item{n}{indicator period}
}
\description{
c++ class documentation
}
\details{
R functions \link{roll_lm}.
}
\section{Usage}{
 \code{RollLinReg( int n )}
}

\section{Public Members and Methods}{

\tabular{lll}{
\cr \strong{Name}                 \tab \strong{Return Type}        \tab \strong{Description}
\cr \code{Add( InputType value )} \tab \code{void}                 \tab update indicator
\cr \code{Reset()}                \tab \code{void}                 \tab reset to initial state
\cr \code{IsFormed()}             \tab \code{bool}                 \tab is indicator value valid?
\cr \code{GetAlphaHistry()}       \tab \code{std::vector< double >}\tab return alpha history
\cr \code{GetBetaHistry()}        \tab \code{std::vector< double >}\tab return beta history
\cr \code{GetRHistry()}           \tab \code{std::vector< double >}\tab return r history
\cr \code{GetRSquaredHistry()}    \tab \code{std::vector< double >}\tab return r squared history
\cr \code{GetValue()}             \tab \code{LinRegCoeffs}         \tab has members \code{double alpha, beta, r, rSquared}
\cr \code{GetHistory()}           \tab \code{DataFrame}            \tab return values history data.table with columns \code{alpha, beta, r, r.squared}
}
}
\seealso{
Other c++ classes: \code{\link{BBands}},
  \code{\link{Candle}}, \code{\link{Cost}},
  \code{\link{Crossover}}, \code{\link{Ema}},
  \code{\link{Indicator}}, \code{\link{Order}},
  \code{\link{Processor}}, \code{\link{RollPercentRank}},
  \code{\link{RollRange}}, \code{\link{RollSd}},
  \code{\link{RollVolumeProfile}}, \code{\link{Rsi}},
  \code{\link{Sma}}, \code{\link{Stochastic}},
  \code{\link{Tick}}

Other c++ indicators: \code{\link{BBands}},
  \code{\link{Crossover}}, \code{\link{Ema}},
  \code{\link{Indicator}}, \code{\link{RollPercentRank}},
  \code{\link{RollRange}}, \code{\link{RollSd}},
  \code{\link{RollVolumeProfile}}, \code{\link{Rsi}},
  \code{\link{Sma}}, \code{\link{Stochastic}}
}

