% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std_.R
\name{std_}
\alias{std_}
\alias{std_IQR}
\alias{std_mad}
\title{Alternative Standardization Methods}
\usage{
std_IQR(x, na.rm = TRUE, ...)

std_mad(x, na.rm = TRUE, ...)
}
\arguments{
\item{x}{\link[base]{numeric} \link[base]{vector}}

\item{na.rm}{\link[base]{logical} scalar,
see \link[stats]{quantile}, \link[stats]{median} and \link[stats]{mad}.
Default \code{TRUE}}

\item{...}{additional parameters of \link[stats]{quantile} and/or \link[stats]{mad}}
}
\value{
\subsection{Standardize using \link[stats]{median} and \link[stats]{IQR}}{

Function \link{std_IQR} returns a \link[base]{numeric} \link[base]{vector} of the same length as \code{x}.
}

\subsection{Standardize using \link[stats]{median} and \link[stats]{mad}}{

Function \link{std_mad} returns a \link[base]{numeric} \link[base]{vector} of the same length as \code{x}.
}
}
\description{
Alternative standardize using \link[stats]{median}, \link[stats]{IQR} and \link[stats]{mad}.
}
\examples{
std_IQR(rnorm(20))
std_mad(rnorm(20))

}
\keyword{internal}
