% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootid.R
\name{bootid}
\alias{bootid}
\title{Bootstrap Indices}
\usage{
bootid(n, R)
}
\arguments{
\item{n}{positive \link[base]{integer} scalar, sample size \eqn{n}}

\item{R}{positive \link[base]{integer} scalar, number of bootstrap replicates \eqn{R}}
}
\value{
Function \link{bootid} returns a length-\eqn{R} \link[base]{list} of
positive \link[base]{integer} \link[base]{vector}s.
Each element is the length-\eqn{n} indices of each bootstrap sample.
}
\description{
Generate a series of \link[boot]{boot}strap indices.
}
\details{
Function \link{bootid} generates the same bootstrap indices as
those generated from the default options of function \link[boot]{boot}
(i.e., \code{sim = 'ordinary'} and \code{m = 0}),
given the same \link[base]{Random} seed.
}
\examples{
set.seed(1345); boot::boot(data = 1:10, statistic = function(data, ind) ind, R = 3L)[['t']]
set.seed(1345); bootid(10L, R = 3L) # same copies of indices

}
\seealso{
\code{boot:::index.array} and \code{boot:::ordinary.array}.
}
\keyword{internal}
