% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D.make.R
\name{D.make}
\alias{D.make}
\title{Generate D Matrix}
\usage{
D.make(
  nQTL,
  type = "RI",
  a = TRUE,
  d = TRUE,
  aa = FALSE,
  dd = FALSE,
  ad = FALSE
)
}
\arguments{
\item{nQTL}{integer. The number of QTLs.}

\item{type}{character. The population type of the dataset. Includes
backcross (type="BC"), advanced intercross population (type="AI"), and
recombinant inbred population (type="RI"). The default value is "RI".}

\item{a}{integer or vector. A integer or vector to determines which
additive effects of QTLs will be considered in this design matrix. If
a=TRUE, the additive effect of all QTLs will be considered. If
a=FALSE, no additive effect will be considered.}

\item{d}{integer or vector. A integer or vector to determines which
dominant effects of QTLs will be considered in this design matrix. If
d=TRUE, the dominant effect of all QTLs will be considered.If
d=FALSE, no dominant effect will be considered.}

\item{aa}{vector or matrix. The additive-by-additive interaction. Two
format can be used in this parameter. One format is a vector, where
every two elements indicate a combination of additive-by-additive
interaction. The other format is a 2*i matrix, where i is the number
of combinations of interaction, and each column indicates the two
interacting QTLs. Additionally, if aa=TRUE, all combinations of
additive-by-additive interaction will be considered. If aa=FALSE, no
additive-by-additive interaction will be considered.}

\item{dd}{vector or matrix. The dominant-by-dominant interaction. The
format is the same as that in aa.}

\item{ad}{vector or matrix. The additive-by-dominant interaction. The
format is the same as that in aa. Note that in each pair of QTLs, the
first element indicates the additive effect, and the second element
indicates the dominant effect.}
}
\value{
The genetic design matrix, where the elements represent the coded
variables of the QTL effects. It is a g*p matrix, where g is the number
of possible QTL genotypes, and p is the number of effects in the MIM
model.
}
\description{
Generate the genetic design matrix of specified QTL number and effects.
}
\note{
For the 'type' parameter, if type="BC", the design matrix exclusively
contains additive effects and additive-by-additive interactions. However,
if type="AI" or type="RI", it encompasses additive and dominance effects
along with all interactions.

For instance, when aa=c(1,3,2,4,5,6), it denotes that the interaction
between QTL1 and QTL3, the interaction between QTL2 and QTL4, and that
between QTL5 and QTL6 will be considered in the design matrix. Furthermore,
the matrix format can be expressed as aa=matrix(c(1,3,2,4,5,6),2,3).
Similarly, parameters DD and AD are also expressed in the same format.
}
\examples{
D.make(4, d = c(1,3,4), aa = c(1,2,2,3), dd = c(1,3,1,4), ad = c(1,2,2,1,2,3,3,4))

aa <- matrix(c(1,2,3,4,4,5), 2, 3)
aa
D.make(5, type = "BC", a = c(1,3,4,5), aa = aa)
}
\references{
KAO, C.-H. and Z.-B. ZENG 1997 General formulas for obtaining the maximum
likelihood estimates and the asymptotic variance-covariance matrix in QTL
mapping when using the EM algorithm. Biometrics 53, 653-665. <doi: 10.2307/2533965.>

KAO, C.-H., Z.-B. ZENG and R. D. TEASDALE 1999 Multiple interval mapping
for Quantitative Trait Loci. Genetics 152: 1203-1216. <doi: 10.1093/genetics/152.3.1203>
}
