% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdq.bias.R
\name{rdq.bias}
\alias{rdq.bias}
\title{Bias estimation}
\usage{
rdq.bias(y, x, dz, x0, z0, taus, h.tau, h.tau2, fx, cov)
}
\arguments{
\item{y}{a numeric vector, the outcome variable.}

\item{x}{a vector (or a matrix) of covariates, the first column is the running variable.}

\item{dz}{the number of covariates.}

\item{x0}{the cutoff point.}

\item{z0}{the value of the covariates at which to evaluate the effects.}

\item{taus}{a vector of quantiles of interest.}

\item{h.tau}{the bandwidth values (specified for each quantile level), for estimating conditional quantiles.}

\item{h.tau2}{the bandwidth values for the local quadratic quantile regression, for estimating the bias terms.}

\item{fx}{conditional density estimates.}

\item{cov}{either 0 or 1. Set \emph{cov=1} if covariates are present in the model;
otherwise set \emph{cov=0}.}
}
\value{
A list with elements:
\describe{
\item{bias}{the bias estimates.}
\item{b.hat}{the estimate of the \eqn{B_{v}(x,z,\tau)} term. See Qu, Yoon, and Perron (2024).}
}
}
\description{
\code{rdq.bias} estimates the bias terms using the local quadratic quantile regression.
}
\examples{
n = 500
x = runif(n,min=-4,max=4)
d = (x > 0)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + rnorm(n)
tlevel = seq(0.1,0.9,by=0.1)
tlevel2 = c(0.05,tlevel,0.95)
hh = rep(2,length(tlevel))
hh2 = rep(2,length(tlevel2))

ab = rdq(y=y,x=x,d=d,x0=0,z0=NULL,tau=tlevel2,h.tau=hh2,cov=0)
delta = c(0.05,0.09,0.14,0.17,0.19,0.17,0.14,0.09,0.05)
hh = rep(2,length(tlevel))
fe = rdq.condf(x,Q=ab$qp.est,bcoe=ab$bcoe.p,taus=tlevel,taul=tlevel2,delta=delta,cov=0)
be = rdq.bias(y[d==1],x[d==1],dz=0,x0=0,z0=NULL,taus=tlevel,hh,hh,fx=fe$ff[(d==1),],cov=0)


}
\references{
Zhongjun Qu, Jungmo Yoon, Pierre Perron (2024), "Inference on Conditional Quantile
Processes in Partially Linear Models with Applications to the Impact of Unemployment Benefits,"
The Review of Economics and Statistics; https://doi.org/10.1162/rest_a_01168
}
