% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AND.R
\name{momAND}
\alias{momAND}
\title{Method of moments (MoM) estimation for the quantile-based asymmetric normal distribution.}
\usage{
momAND(y, alpha = NULL)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.  If \eqn{\alpha} is unknown, indicate NULL which is the default option. In this case, the sample skewness will be used to estimate \eqn{\alpha}. If \eqn{\alpha} is known, then the value of \eqn{\alpha} has to be specified in the function.}
}
\value{
\code{\link{momAND}} provides the method of moments estimates of the unknown parameters of the distribution.
}
\description{
Parameter estimation in the quantile-based asymmetric normal distribution by using method of moments are discussed in Gijbels et al. (2019a).
}
\examples{
# Example
y=rnorm(100)
momAND(y=y,alpha=0.5) # If alpha is known wtih alpha=0.5
momAND(y=y) # If alpha is unknown

}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, \url{https://doi.org/10.1111/insr.12324}.
}
}
