% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SemiRegALaD.R
\name{SemiQRegALaD}
\alias{SemiQRegALaD}
\alias{locpolALaD_x0}
\alias{locpolALaD}
\title{Semiparametric quantile regression in quantile-based asymmetric Laplace distributional settings.}
\usage{
locpolALaD_x0(x, y, p1 = 1, p2 = 1, h, alpha = 0.5, x0,
  tol = 1e-08)

locpolALaD(x, y, p1 = 1, p2 = 1, h, alpha = 0.5, m = 101)

SemiQRegALaD(beta, x, y, p1 = 1, p2 = 1, h, alpha = NULL, m = 101)
}
\arguments{
\item{x}{This a conditioning covariate.}

\item{y}{The is a response variable.}

\item{p1}{This is the order of the Taylor expansion for the location function (i.e.,\eqn{\mu(X)}) in local polynomial fitting technique. The default value is 1.}

\item{p2}{This is the order of the Taylor expansion for the log of scale function (i.e., \eqn{\ln[\phi(X)]}) in local polynomial fitting technique. The default value is 1.}

\item{h}{This is the bandwidth parameter \eqn{h}.}

\item{alpha}{This is the index parameter  \eqn{\alpha} of the quantile-based asymmetric Laplace density. The default value is 0.5 in the codes code \code{\link{locpolALaD_x0}} and code \code{\link{locpolALaD}}. The default value of \eqn{\alpha} is NULL in the code \code{\link{SemiQRegALaD}}. In this case, the \eqn{\alpha} will be estimated based on the residuals of local linear mean regression.}

\item{x0}{This is a grid-point \eqn{x_0} at which the function is to be estimated.}

\item{tol}{the desired accuracy. See details in \code{\link[stats]{optimize}}.}

\item{m}{This is the number of grid points at which the functions are to be evaluated. The default value is 101.}

\item{beta}{This is a specific probability for estimating \eqn{\beta}th quantile function.}
}
\value{
The code \code{\link{locpolALaD_x0}} provides the realized value of the local maximum likelihood estimator of \eqn{\widehat{\theta}_{rj}(x_0)} for \eqn{(r\in \{1,2\}; j=1,2,...,p_r)} with the estimated approximate asymptotic bias and variance at the grind point \eqn{x_0} discussed in Gijbels et al. (2019c).

The code \code{\link{locpolALaD}} provides the realized value of the local maximum likelihood estimator of \eqn{\widehat{\theta}_{r0}(x_0)} for \eqn{(r\in \{1,2\})} with the estimated approximate asymptotic bias and variance at all \eqn{m} grind points \eqn{x_0} discussed in Gijbels et al. (2019c).

The code \code{\link{SemiQRegALaD}} provides the realized value of the \eqn{\beta}th conditional quantile estimator by using semiparametric quantile regression technique discussed in Gijbels et al. (2019b) and Gijbels et al. (2019c).
}
\description{
The local polynomial technique is used to estimate location and scale function of the quantile-based asymmetric Laplace distribution discussed in Gijbels et al. (2019c).
The semiparametric quantile estimation technique is used to estimate \eqn{\beta}th conditional quantile function in quantile-based asymmetric Laplace distributional setting discussed in Gijbels et al. (2019b) and Gijbels et al. (2019c).
}
\examples{
\donttest{
data(Hurricane)
locpolALaD_x0(Hurricane$Year, Hurricane$WmaxST, p1=1,p2=1,h=2.18,
 alpha=0.16,x0=median(Hurricane$Year))
 }
\donttest{
data(Hurricane)
locpolALaD(Hurricane$Year, Hurricane$WmaxST, p1=1,p2=1,h=2.18, alpha=0.16)
}
\donttest{
## For Hurricane Data
data(Hurricane)
Hurricane<-Hurricane[which(Hurricane$Year>1970),]

plot(Hurricane$Year,Hurricane$WmaxST)

h=2.181082
alpha=0.1649765
gridPoints=101
fit_ALaD <-locpolALaD(Hurricane$Year, Hurricane$WmaxST, p1=1,p2=1,h=h, alpha=alpha, m = gridPoints)
str(fit_ALaD)
par(mgp=c(2,.4,0),mar=c(5,4,4,1)+0.01)

# For phi plot
plot(fit_ALaD$x0,exp(fit_ALaD$theta_20),ylab=expression(widehat(phi)(x[0])),xlab="Year",
type="l",font.lab=2,cex.lab=1.5,bty="l",cex.axis=1.5,lwd =3)

## For theta2 plot
plot(fit_ALaD$x0,fit_ALaD$theta_20,ylab=expression(bold(widehat(theta[2]))(x[0])),
xlab="Year",type="l",col=c(1), lty=1, font.lab=1,cex.lab=1.5,bty="l",cex.axis=1.3,lwd =3)



#### Estimated Quantile lines by ALaD
par(mgp=c(2.5, 1, 0),mar=c(5,4,4,1)+0.01)
# X11()
plot(Hurricane$Year, Hurricane$WmaxST, xlab = "Year",ylim=c(20,210),
ylab = "Maximum Wind Spreed",font.lab=1,cex.lab=1.3,bty="l",pch=20,cex.axis=1.3)

lines(fit_ALaD$x0,fit_ALaD$theta_10, type='l',col=c(4),lty=1,lwd =3)

#####  Conditioanl Quantile line for ALaD

lines(fit_ALaD$x0,SemiQRegALaD(beta=0.50,Hurricane$Year, Hurricane$WmaxST,
p1=1,p2=1, h=h,alpha=alpha,m=gridPoints)$fit_beta_ALaD,type='l',col=c(1),lty=1,lwd =3)


lines(fit_ALaD$x0,SemiQRegALaD(beta=0.90,Hurricane$Year, Hurricane$WmaxST,
p1=1,p2=1, h=h,alpha=alpha,m=gridPoints)$fit_beta_ALaD,type='l',col=c(14),lty=1,lwd =3)
lines(fit_ALaD$x0,SemiQRegALaD(beta=0.95,Hurricane$Year, Hurricane$WmaxST,
p1=1,p2=1, h=h,alpha=alpha,m=gridPoints)$fit_beta_ALaD,type='l',col=c(19),lty=1,lwd =3)

# Add local linear mean regression line
library(locpol)
fit_mean<-locpol(WmaxST~Year, data=Hurricane,kernel=gaussK,deg=1,
xeval=NULL,xevalLen=101)

lines(fit_mean$lpFit[,1], fit_mean$lpFit[,2],type='l',col=c(2),lty=1,lwd =3)
axis(1, at = c(1975, 1985, 1995,2005,2015),cex.axis=1.3)
axis(2, at = c(25, 75, 125,175),cex.axis=1.3)

legend("topright", legend = c(expression(beta==0.1650), expression(beta==0.50),
"Mean line",expression(beta==0.90), expression(beta==0.95)), col = c(4,1,2,14,19),
 lty=c(1,1,1,1,1), inset = 0, lwd = 3,cex=1.2)
}
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019b). Quantile estimation in a generalized  asymmetric distributional setting. To appear in \emph{Springer Proceedings in Mathematics & Statistics, Proceedings of `SMSA 2019', the 14th Workshop on Stochastic Models, Statistics and their Application}, Dresden, Germany, in March 6--8, 2019. Editors: Ansgar Steland, Ewaryst Rafajlowicz, Ostap Okhrin.

Gijbels, I., Karim, R. and Verhasselt, A. (2019c).  Semiparametric quantile regression using quantile-based asymmetric family of densities. Manuscript.


}
}
