% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR.R
\name{LRTest}
\alias{LRTest}
\title{Likelihood ratio test to test for symmetry.}
\usage{
LRTest(y, f)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{f}{This is the reference density function \eqn{f} which is a standard version of a unimodal and symmetric around 0 density.}
}
\value{
The likelihood ratio test statistic with \eqn{P}-value.
}
\description{
The likelihood ratio test to test for symmetry, in the context of a framework of quantile-based asymmetric family of densities is discussed in Gijbels et al. (2019d).
}
\examples{
# Example: Let F be a standard normal cumulative distribution function then
f_N<-function(s){dnorm(s, mean = 0,sd = 1)} # density function of N(0,1)
rnum=rnorm(100)
LRTest(rnum,f=f_N)
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019d). Test of symmetry and a quantile-based asymmetric family of densities, \emph{Manuscript}.
}
}
